/*
 * Rahmenwerk-Plug-in "BitCtrl-Bibliotheken"
 *
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.rw.bitctrl.eclipse.actions;

import java.util.Date;
import java.util.List;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.widgets.Shell;

import de.bsvrz.buv.rw.basislib.kalender.IEintragBereich;
import de.bsvrz.buv.rw.basislib.kalender.KalenderBereichDialog;
import de.bsvrz.buv.rw.basislib.kalender.KalenderBereichDialog.Quelle;
import de.bsvrz.buv.rw.bitctrl.internal.BitCtrlRahmenwerkPlugin;
import de.bsvrz.sys.funclib.bitctrl.modell.util.ObjektMitZeitBereich;

/**
 * Aktion, welcher einen Dialog zum Auswählen eines Systemkalendereintrags
 * öffnet.
 *
 * @author BitCtrl Systems GmbH, Andreas Meissner
 */
public class UebernehmeSystemKalenderZeitbereichAction extends Action {

	private final Shell shell;
	private final ObjektMitZeitBereich objekt;

	/**
	 * Der Konstruktor.
	 *
	 * @param shell
	 *            die aktuelle Shell, darf nicht <code>null</code> sein
	 * @param objekt
	 *            ein Objekt dessen Zeitbereich angepasst werden soll, darf
	 *            nicht <code>null</code> sein
	 */
	public UebernehmeSystemKalenderZeitbereichAction(final Shell shell,
			final ObjektMitZeitBereich objekt) {

		assert shell != null;
		assert objekt != null;

		this.shell = shell;
		this.objekt = objekt;

		setText("Übernimm den Zeitbereich eines Kalendereintrags");
		setToolTipText("Übernimm den Zeitbereich eines Kalendereintrags");
		setImageDescriptor(
				BitCtrlRahmenwerkPlugin.getDefault().getImageDescriptor(
						"icons/aktionen/zeitbereich_uebernehmen.gif"));
	}

	@Override
	public void run() {
		final KalenderBereichDialog bereichsDialog = new KalenderBereichDialog(
				shell, Quelle.systemkalender);
		if (bereichsDialog.open() == Window.OK) {
			final List<IEintragBereich> bereiche = bereichsDialog
					.getSelektierteBereiche();
			if (bereiche != null && !bereiche.isEmpty()) {
				final IEintragBereich ersterBereich = bereiche.get(0);
				final Date dieNeueStartZeit = new Date(ersterBereich.getVon());
				final Date dieNeueEndZeit = new Date(ersterBereich.getBis());
				objekt.setStartZeit(dieNeueStartZeit);
				objekt.setEndZeit(dieNeueEndZeit);
			}
		}
	}
}
