/*
 * Rahmenwerk-Plug-in "BitCtrl-Bibliotheken"
 *
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.rw.bitctrl.eclipse.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PartInitException;

/**
 * Basisklasse für Action Delegates die eine View öffnen.
 *
 * @author BitCtrl Systems GmbH, Falko Schumann
 *
 * @todo nach rw.bitctrl verschieben?
 */
public class ViewActionDelegate implements IWorkbenchWindowActionDelegate {

	private final String viewId;
	private IWorkbenchWindow workbenchWindow;

	/**
	 * Initialisiert die Action.
	 *
	 * @param viewId
	 *            die ID der zu öffnenden Perspektive.
	 */
	protected ViewActionDelegate(final String viewId) {
		this.viewId = viewId;
	}

	@Override
	public void init(final IWorkbenchWindow window) {
		workbenchWindow = window;
	}

	@Override
	public void selectionChanged(final IAction action,
			final ISelection selection) {
		// tut nix
	}

	@Override
	public void run(final IAction action) {
		try {
			workbenchWindow.getActivePage().showView(viewId);
		} catch (final PartInitException ex) {
			throw new IllegalStateException(ex);
		}
	}

	@Override
	public void dispose() {
		// tut nix
	}

}
