/*
 * Rahmenwerk-Plug-in "BitCtrl-Bibliotheken"
 *
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.rw.bitctrl.eclipse.adapter;

import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.ui.IActionFilter;

import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.sys.funclib.bitctrl.modell.SystemObjekt;

public class SystemObjectAdapterFactory implements IAdapterFactory {

	private final IActionFilter systemObjectIActionFilter = new SystemObjectIActionFilterAdapter();

	@Override
	public Object getAdapter(final Object adaptableObject,
			final Class adapterType) {
		if (IActionFilter.class.isAssignableFrom(adapterType)
				&& (adaptableObject instanceof SystemObject
						|| adaptableObject instanceof SystemObjekt)) {
			return systemObjectIActionFilter;
		}
		return null;
	}

	@Override
	public Class[] getAdapterList() {
		return new Class[] { IActionFilter.class };
	}

}
