/*
 * Rahmenwerk-Plug-in "BitCtrl-Bibliotheken"
 *
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.rw.bitctrl.eclipse.databinding;

import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;

import com.bitctrl.lib.eclipse.databinding.observables.AbstractSWTObservableValue;

import de.bsvrz.buv.rw.basislib.kalender.CompositeZeitDauer;

public class CompositeZeitDauerObservableValue
		extends AbstractSWTObservableValue {

	private final CompositeZeitDauer zeitDauer;
	private final SelectionListener listener;
	private Long currentValue;
	private boolean updating;
	private final ModifyListener modifyLister;

	/**
	 * @param zeitDauerExtended
	 */
	public CompositeZeitDauerObservableValue(
			final CompositeZeitDauer zeitDauerExtended) {
		super(zeitDauerExtended);
		zeitDauer = zeitDauerExtended;
		currentValue = doGetValue();
		listener = new SelectionListener() {
			@Override
			public void widgetDefaultSelected(final SelectionEvent e) {
				widgetSelected(e);
			}

			@Override
			public void widgetSelected(final SelectionEvent e) {
				if (!updating) {
					final Long oldValue = currentValue;
					currentValue = doGetValue();
					fireValueChange(
							Diffs.createValueDiff(oldValue, currentValue));
				}
			}
		};

		zeitDauerExtended.addSelectionListener(listener);

		modifyLister = e -> {
			if (!updating) {
				final Long oldValue = currentValue;
				currentValue = doGetValue();
				fireValueChange(Diffs.createValueDiff(oldValue, currentValue));
			}
		};
		zeitDauerExtended.addModifyListener(modifyLister);
	}

	@Override
	public void doSetValue(final Object value) {

		final Long oldValue = doGetValue();
		try {
			updating = true;
			zeitDauer.setZeitDauerInBezugAufAnfangsZeitpunkt(
					value instanceof Long ? (Long) value : 0);
			currentValue = doGetValue();
		} finally {
			updating = false;
		}
		fireValueChange(Diffs.createValueDiff(oldValue, currentValue));
	}

	@Override
	public Long doGetValue() {
		return zeitDauer.getZeitDauer();
	}

	@Override
	public Object getValueType() {
		return Long.TYPE;
	}

	@Override
	public synchronized void dispose() {
		zeitDauer.removeSelectionListener(listener);
		zeitDauer.removeModifyListener(modifyLister);
		super.dispose();
	}
}
