/*
 * Rahmenwerk-Plug-in "BitCtrl-Bibliotheken"
 *
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.rw.bitctrl.eclipse.databinding;

import java.util.Date;

import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;

import com.bitctrl.lib.eclipse.databinding.observables.AbstractSWTObservableValue;

import de.bsvrz.buv.rw.basislib.kalender.DatumZeit;

public final class DatumZeitObservableZeitPunkt
		extends AbstractSWTObservableValue {
	private final DatumZeit datumZeit;
	private SelectionListener zuhoerer;

	public DatumZeitObservableZeitPunkt(final DatumZeit datumZeit) {
		super(datumZeit);
		this.datumZeit = datumZeit;
	}

	public DatumZeitObservableZeitPunkt(final Realm realm,
			final DatumZeit datumZeit) {
		super(realm, datumZeit);
		this.datumZeit = datumZeit;
	}

	@Override
	protected void firstListenerAdded() {
		zuhoerer = new SelectionAdapter() {
			@Override
			public void widgetSelected(final SelectionEvent e) {
				valueHasChanged();
			}
		};
		datumZeit.hinzufuegenSelektionsZuhoerer(zuhoerer);
		super.firstListenerAdded();
	}

	@Override
	protected void lastListenerRemoved() {
		datumZeit.entferneSelektionsZuhoerer(zuhoerer);
		super.lastListenerRemoved();
	}

	@Override
	public Class<Date> getValueType() {
		return Date.class;
	}

	@Override
	protected Object doGetValue() {
		return datumZeit.getDatum();
	}

	@Override
	protected void doSetValue(final Object value) {
		datumZeit.setDatum((Date) value);
	}
}