/*
 * Rahmenwerk-Plug-in "BitCtrl-Bibliotheken"
 *
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.rw.bitctrl.eclipse.databinding.converter;

import org.eclipse.core.databinding.conversion.IConverter;

import de.bsvrz.sys.funclib.bitctrl.modell.tmtmcglobal.attribute.AttTmcRichtung;

/**
 * Ein DataBinding-Converter, welcher ein Richtungsobjekt zu einem Boolean-Wert
 * konvertiert.
 *
 * @author BitCtrl Systems GmbH, Andreas Meissner
 *
 */
public class TmcRichtungToBooleanConverter implements IConverter {

	private final AttTmcRichtung trueRichtung;

	/**
	 * Der Konstruktor.
	 *
	 * @param trueRichtung
	 *            die Richtung, welche zum Boolean-Wert <code>true</code>
	 *            gemappt werden soll
	 */
	public TmcRichtungToBooleanConverter(final AttTmcRichtung trueRichtung) {
		this.trueRichtung = trueRichtung;
	}

	@Override
	public Object convert(final Object fromObject) {
		if (!(fromObject instanceof final AttTmcRichtung fromRichtung)) {
			return null;
		}
		if (fromRichtung == trueRichtung) {
			return true;
		}
		return false;
	}

	@Override
	public Object getFromType() {
		return AttTmcRichtung.class;
	}

	@Override
	public Object getToType() {
		return boolean.class;
	}
}
