/*
 * Rahmenwerk-Plug-in "BitCtrl-Bibliotheken"
 *
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.rw.bitctrl.eclipse.dialogs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

import de.bsvrz.dav.daf.main.ClientDavInterface;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.dav.daf.main.config.SystemObjectType;
import de.bsvrz.sys.funclib.bitctrl.util.SystemObjectComparator;

/**
 * Baut einen Baum aus Systemobjekttypen und Systemobjekten auf. Der Baum hat
 * nur zwei Ebenen, die erste Ebene enthält die Systemobjekttypen und die zweite
 * die jeweiligen Systemobjekte.
 *
 * <p>
 * Das <code>input</code>-Objekt ist beliebig, es werden alle Systemobjekttypen
 * und Systemobjekte bestimmt. Wird allerdings als <code>input</code>-Objekt ein
 * {@link SystemObjectType} angegeben, schränkt dieser den Baum auf den
 * angegegeben Typ und seine Subtypen ein.
 *
 * @author BitCtrl Systems GmbH, Falko Schumann
 *
 */
public class SystemObjectTreeContentProvider implements ITreeContentProvider {

	@Override
	public Object[] getElements(final Object inputElement) {
		final List<SystemObject> objectTypes;

		if (inputElement instanceof final SystemObjectType type) {
			objectTypes = new ArrayList<>(type.getSubTypes());
		} else {
			final ClientDavInterface dav = (ClientDavInterface) inputElement;
			final SystemObjectType type = dav.getDataModel().getType("typ.typ");
			objectTypes = new ArrayList<>(type.getObjects());
		}

		final Iterator<SystemObject> iterator = objectTypes.iterator();
		while (iterator.hasNext()) {
			final SystemObjectType type = (SystemObjectType) iterator.next();
			if (type.getObjects().isEmpty()) {
				iterator.remove();
			}
		}
		Collections.sort(objectTypes, new SystemObjectComparator());
		return objectTypes.toArray();
	}

	@Override
	public boolean hasChildren(final Object element) {
		if (element instanceof final SystemObjectType type) {
			return !type.getObjects().isEmpty();
		}

		return false;
	}

	@Override
	public Object[] getChildren(final Object parentElement) {
		if (parentElement instanceof final SystemObjectType type) {
			final List<SystemObject> objects = new ArrayList<>(
					type.getObjects());
			Collections.sort(objects, new SystemObjectComparator());
			return objects.toArray();
		}

		return new Object[0];
	}

	@Override
	public Object getParent(final Object element) {
		if (element instanceof final SystemObject so
				&& !(element instanceof SystemObjectType)) {
			return so.getType();
		}
		return null;
	}

	@Override
	public void dispose() {
		// tut nix
	}

	@Override
	public void inputChanged(final Viewer viewer, final Object oldInput,
			final Object newInput) {
		// tut nix
	}

}