/*
 * Rahmenwerk-Plug-in "BitCtrl-Bibliotheken"
 *
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.rw.bitctrl.eclipse.editors;

import org.eclipse.emf.ecore.EObject;

import com.bitctrl.lib.eclipse.emf.editors.EmfEditorInput;

import de.bsvrz.buv.rw.basislib.einstellungen.SpeicherKey;

/**
 * Erweitert das EMF-Editor-Input um eine Einstellungsart.
 *
 * @author BitCtrl Systems GmbH, Falko Schumann
 *
 */
public class EmfEinstellungenEditorInput extends EmfEditorInput {

	private final SpeicherKey einstellungsArt;

	/**
	 * Initialisiert den Editor Input.
	 *
	 * @param object
	 * @param einstellungsArt
	 */
	public EmfEinstellungenEditorInput(final EObject object,
			final SpeicherKey einstellungsArt) {
		super(object);
		this.einstellungsArt = einstellungsArt;
	}

	/**
	 * Gibt die Einstellungsart zurück.
	 *
	 * @return die Einstellungsart.
	 */
	public SpeicherKey getEinstellungsArt() {
		return einstellungsArt;
	}

	/**
	 * Erweitert um einen Adapter für {@link SpeicherKey}.
	 */
	@Override
	public Object getAdapter(final Class adapter) {
		if (adapter == SpeicherKey.class) {
			return einstellungsArt;
		}

		return super.getAdapter(adapter);
	}

	@Override
	public String toString() {
		StringBuilder result = new StringBuilder().append(getClass().getName());

		result.append("(");
		result.append("einstellungsArt=").append(einstellungsArt);
		result.append(", object=").append(getAdapter(EObject.class));
		result.append(", exists=").append(exists());
		result.append(")");

		return result.toString();
	}
}
