/*
 * Rahmenwerk-Plug-in "BitCtrl-Bibliotheken"
 *
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.rw.bitctrl.eclipse.modell;

import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.map.WritableMap;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.jface.window.Window;

import com.bitctrl.lib.eclipse.actions.LoadAction;
import com.bitctrl.lib.eclipse.databinding.observables.ObservableMapKeySet;
import com.bitctrl.lib.eclipse.databinding.wizards.EnterOrSelectStringWizardPage;
import com.bitctrl.lib.eclipse.wizards.ComposedWizardDialog;

import de.bsvrz.buv.rw.basislib.Rahmenwerk;
import de.bsvrz.buv.rw.basislib.einstellungen.EinstellungLocation;
import de.bsvrz.buv.rw.basislib.einstellungen.EinstellungOwnerType;
import de.bsvrz.buv.rw.basislib.einstellungen.SpeicherKey;
import de.bsvrz.buv.rw.bitctrl.eclipse.Messages;
import de.bsvrz.buv.rw.bitctrl.eclipse.modell.ModellEinstellungen.WizardPageItem;
import de.bsvrz.buv.rw.bitctrl.eclipse.wizards.SelectEinstellungsArtWizardPage;
import de.bsvrz.buv.rw.bitctrl.internal.RahmenwerkService;

/**
 * Läd ein Modell aus dem Datenverteiler. Fragt den Anwender nach der
 * {@link EinstellungsArt} und welches der gespeicherten Modelle geladen werden
 * soll. Wird verwendet, um benutzer-spezifisch gespeicherte Einstellungen zu
 * laden.
 *
 * @author BitCtrl Systems GmbH, schnepel
 *
 * @param <N>
 *            Typ der konkreten Named Klasse
 * @param <T>
 *            der gespeicherte Typ
 */
public abstract class ModellLoadAction<N, T> extends LoadAction {
	/**
	 * Konstruktor, der den ToolTipText setzt.
	 */
	public ModellLoadAction() {
		setToolTipText("Einstellungen laden");
	}

	/**
	 * Verarbeitet das geladene Objekt.
	 *
	 * @param object
	 *            das geladene Objekt
	 */
	protected abstract void doLoad(final T object);

	@SuppressWarnings("unchecked")
	@Override
	public final void run() {

		final Rahmenwerk rahmenwerk = RahmenwerkService.getService()
				.getRahmenWerk();
		if (!rahmenwerk.isOnline()) {
			return;
		}

		final IObservableValue newName = new WritableValue("", String.class);
		final IObservableMap cps = new WritableMap();
		final IObservableValue artValue = new WritableValue(null,
				SpeicherKey.class);
		final ModellEinstellungen<N, T> modelEinstellungen = createModelEinstellungen();
		artValue.addValueChangeListener(event -> {
			cps.clear();
			final SpeicherKey art = (SpeicherKey) artValue.getValue();
			if (null != art) {
				cps.putAll(modelEinstellungen.getModellEinstellungen(art));
			}
		});
		artValue.setValue(new SpeicherKey(EinstellungOwnerType.BENUTZER,
				EinstellungLocation.NETZWERKWEIT,
				rahmenwerk.getBenutzer().getPid()));
		final SelectEinstellungsArtWizardPage page1 = new SelectEinstellungsArtWizardPage(
				artValue);
		// TODO extend EnterOrSelectStringWizardPage to display multiple columns
		final EnterOrSelectStringWizardPage page2 = new EnterOrSelectStringWizardPage(
				Messages.EMFModelLoadAction_WizardHeader, null, null, null,
				Messages.EMFModelLoadAction_WizardPrompt, newName,
				new ObservableMapKeySet(cps));
		final ComposedWizardDialog wizard = new ComposedWizardDialog(
				Messages.EMFModelLoadAction_WizardCaption, page1, page2);
		if (wizard.open() == Window.OK) {
			final WizardPageItem<T> wizardPageItem = (WizardPageItem<T>) cps
					.get(newName.getValue());
			if (null != wizardPageItem) {
				doLoad(wizardPageItem.getObject());
			}
		}
	}

	/**
	 * Erstellt ein Objekt vom Typ {@link ModellEinstellungen}.
	 *
	 * @return das Objekt
	 */
	protected abstract ModellEinstellungen<N, T> createModelEinstellungen();

}