/*
 * Rahmenwerk-Plug-in "BitCtrl-Bibliotheken"
 *
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.rw.bitctrl.eclipse.modell.java;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

import de.bsvrz.buv.rw.bitctrl.eclipse.modell.ModellEinstellungen;
import de.bsvrz.buv.rw.bitctrl.eclipse.modell.java.storage.Named;

/**
 * Implementietr das Speichern der Modelleinstellungen als Java-Serialisierte
 * Einstellungen.
 *
 * @author BitCtrl Systems GmbH, Falko Schumann
 *
 * @param <T>
 *            der gespeicherte Typ
 * @see Serializable
 */
public class SerializedModellEinstellungen<T>
		extends ModellEinstellungen<Named, T> {

	/**
	 *
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * Konstruktor.
	 *
	 * @param type
	 *            Klasse des gespeicherten Typs
	 */
	public SerializedModellEinstellungen(final Class<T> type) {
		super(type);
	}

	@Override
	protected T getObject(final Named named) {
		return (T) named.getObject();
	}

	@Override
	protected void setObject(final Named named, final T object) {
		named.setObject(object);
	}

	@Override
	protected String getName(final Named named) {
		return named.getName();
	}

	@Override
	protected void setName(final Named named, final String name) {
		named.setName(name);
	}

	@Override
	protected void setLastModification(final Named named,
			final Date lastModification) {
		named.setLastModification(lastModification);
	}

	@Override
	protected Date getLastModification(final Named named) {
		return named.getLastModification();
	}

	@Override
	protected Named createStorage() {
		return new Named();
	}

	@Override
	protected List<Named> getModellEinstellungenInternal(final String param) {
		if (param != null && !param.isEmpty()) {
			try {
				final byte[] buffer = Base64.getDecoder().decode(param);
				final ObjectInputStream inputStream = new ObjectInputStream(
						new ByteArrayInputStream(buffer));
				return (List<Named>) inputStream.readObject();
			} catch (final IOException | ClassNotFoundException ex) {
				handleReadError(ex, null);
			}
		}

		return new ArrayList<>();
	}

	@Override
	protected String saveModellEinstellungenInternal(
			final List<Named> contents) {
		final Iterator<Named> iterator = contents.iterator();
		while (iterator.hasNext()) {
			if (iterator.next().getObject() == null) {
				iterator.remove();
			}
		}

		try (final ByteArrayOutputStream buffer = new ByteArrayOutputStream();
				final ObjectOutputStream outputStream = new ObjectOutputStream(
						buffer)) {
			outputStream.writeObject(contents);
			return (Base64.getEncoder().encodeToString(buffer.toByteArray()));
		} catch (final IOException ex) {
			handleWriteError(ex, null);
		}

		return "";
	}

}
