/*
 * Rahmenwerk-Plug-in "BitCtrl-Bibliotheken"
 *
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.rw.bitctrl.eclipse.properties;

import java.util.List;

import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.PropertyDescriptor;

import de.bsvrz.buv.rw.bitctrl.eclipse.viewers.MultiSystemObjectCellEditor;
import de.bsvrz.dav.daf.main.config.SystemObjectType;

/**
 * Descriptor für eine Property die mehrere Systemobjekte als {@link List}
 * beschreibt. Als Editor wird dem Anwender ein Dialog präsentiert, in dem er
 * ein eines oder mehrere Systemobjekt auswählen kann.
 *
 * @author BitCtrl Systems GmbH, Falko Schumann
 *
 */
public class MultiSystemObjectPropertyDescriptor extends PropertyDescriptor {

	private final SystemObjectType systemObjectType;

	/**
	 * Initialisiert den Property Descriptor.
	 *
	 * @param id
	 * @param displayName
	 * @param systemObjectType
	 *            der Systemobjekttyp von dem die ausgewählten Objekte sein
	 *            sollen.
	 */
	public MultiSystemObjectPropertyDescriptor(final Object id,
			final String displayName, final SystemObjectType systemObjectType) {
		super(id, displayName);
		this.systemObjectType = systemObjectType;
	}

	@Override
	public CellEditor createPropertyEditor(final Composite parent) {
		final CellEditor editor = new MultiSystemObjectCellEditor(parent,
				systemObjectType);
		if (getValidator() != null) {
			editor.setValidator(getValidator());
		}
		return editor;
	}

}
