/*
 * Rahmenwerk-Plug-in "BitCtrl-Bibliotheken"
 *
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.rw.bitctrl.eclipse.util;

import de.bsvrz.buv.rw.basislib.Rahmenwerk;
import de.bsvrz.buv.rw.bitctrl.internal.RahmenwerkService;
import de.bsvrz.sys.funclib.bitctrl.modell.util.benutzer.Benutzerverwaltung;

/**
 * Enthält allgemeine Hilfsmethoden zum Rahmenwerk.
 *
 * @author BitCtrl Systems GmbH, Falko Schumann
 *
 */
public final class RahmenwerkUtils {

	/**
	 * Prüft, ob der angemeldete Benutzer ein Administrator ist.
	 *
	 * @return <code>true</code>, wenn der angemeldete Benutzer Administrator
	 *         ist oder keine Verbindung zum Datenverteiler besteht.
	 */
	public static boolean isAdmin() {
		final Rahmenwerk rahmenwerk = RahmenwerkService.getService()
				.getRahmenWerk();
		if (!rahmenwerk.isOnline()) {
			return true;
		}

		final String loginname = rahmenwerk.getBenutzerName();
		final String passwort = rahmenwerk.getPasswort();
		final Benutzerverwaltung benutzerverwaltung = new Benutzerverwaltung(
				RahmenwerkService.getService().getObjektFactory());
		return benutzerverwaltung.isDAVAdmin(loginname, passwort);
	}

	private RahmenwerkUtils() {
		// utility class
	}

}
