/*
 * Rahmenwerk-Plug-in "BitCtrl-Bibliotheken"
 *
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.rw.bitctrl.eclipse.viewers;

import java.util.List;

import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;

import de.bsvrz.buv.rw.bitctrl.eclipse.dialogs.SystemObjectSelectionDialog;
import de.bsvrz.buv.rw.bitctrl.internal.RahmenwerkService;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.dav.daf.main.config.SystemObjectType;

/**
 * Cell Editor für {@link List}e von Systemobjekte.
 *
 * @author BitCtrl Systems GmbH, Falko Schumann
 *
 */
public class MultiSystemObjectCellEditor extends DialogCellEditor {

	private final SystemObjectType systemObjectType;

	/**
	 * Initialisiert den Cell Editor.
	 *
	 * @param parent
	 * @param systemObjectType
	 *            der Systemobjekttyp von dem die ausgewählten Objekte sein
	 *            sollen.
	 */
	public MultiSystemObjectCellEditor(final Composite parent,
			final SystemObjectType systemObjectType) {
		super(parent);
		this.systemObjectType = systemObjectType;
	}

	@Override
	protected Object openDialogBox(final Control cellEditorWindow) {
		final Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow()
				.getShell();
		final SelectionDialog dialog;
		if (systemObjectType != null) {
			dialog = SystemObjectSelectionDialog
					.createMultiSelectionDialog(shell, systemObjectType);
		} else {
			dialog = SystemObjectSelectionDialog.createTreeSelectionDialog(
					shell,
					RahmenwerkService.getService().getObjektFactory().getDav());
		}
		final List<SystemObject> value = (List<SystemObject>) getValue();
		if (value != null) {
			dialog.setInitialElementSelections(value);
		}
		if (dialog.open() == Window.OK) {
			return SystemObjectSelectionDialog.getSelectedObjects(dialog);
		}

		return null;
	}

}
