/*
 * Rahmenwerk-Plug-in "BitCtrl-Bibliotheken"
 *
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.rw.bitctrl.eclipse.viewers;

import java.util.Collections;

import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;

import de.bsvrz.buv.rw.bitctrl.eclipse.dialogs.SystemObjectSelectionDialog;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.dav.daf.main.config.SystemObjectType;

/**
 * Cell Editor für ein Systemobjekt.
 *
 * @author BitCtrl Systems GmbH, Falko Schumann
 *
 */
public class SingleSystemObjectCellEditor extends DialogCellEditor {

	private final SystemObjectType systemObjectType;

	/**
	 * Initialisiert den Cell Editor.
	 *
	 * @param parent
	 * @param systemObjectType
	 *            der Systemobjekttyp von dem das ausgewählte Objekt sein soll.
	 */
	public SingleSystemObjectCellEditor(final Composite parent,
			final SystemObjectType systemObjectType) {
		super(parent);
		this.systemObjectType = systemObjectType;
	}

	@Override
	protected Object openDialogBox(final Control cellEditorWindow) {
		final Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow()
				.getShell();
		final SelectionDialog dialog = SystemObjectSelectionDialog
				.createListSelectionDialog(shell, systemObjectType, SWT.SINGLE);
		final SystemObject so = (SystemObject) getValue();
		if (so != null) {
			dialog.setInitialElementSelections(Collections.singletonList(so));
		}
		if (dialog.open() == Window.OK) {
			return SystemObjectSelectionDialog.getFirstSelectedObject(dialog);
		}

		return null;
	}

}
