/*
 * Rahmenwerk-Plug-in "BitCtrl-Bibliotheken"
 *
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
/* Copyright by BitCtrl Systems Leipzig */
/* BitCtrl Systems Leipzig */
/* Weisenfelser Str. 67 */
/* 04229 Leipzig */
/* Tel.: +49 341 49067 - 0 */
/* Fax.: +49 341 49067 - 15 */
/* mailto:info@bitctrl.de */
/* http://www.bitctrl.de */
/*---------------------------------------------------------------*/
package de.bsvrz.buv.rw.bitctrl.eclipse.wizards;

import java.util.Date;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.IMessageProvider;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

import de.bsvrz.buv.rw.basislib.kalender.DatumZeit;
import de.bsvrz.dav.daf.main.Data;
import de.bsvrz.dav.daf.main.config.TimeAttributeType;

/**
 * Dialog für die Auswahl eines absoluten Zeitpunktes. Intern wird das vom
 * Rahmenwerk bereitgestellte Widget {@link DatumZeit} verwendet.
 *
 * @author BitCtrl Systems GmbH, Albrecht Uhlmann
 *
 */
public class DatumZeitDialog extends ZeitAuswahlDialog {

	private DatumZeit datumZeit;

	/**
	 * Konstruktor mit üblichem long-Wert (muss >= 0 sein) - Millisekunden seit
	 * 1.1.1970
	 *
	 * @param parentShell
	 *            Eltern-shell
	 * @param initialValue
	 *            Initialwert für das {@link DatumZeit}-Widget.
	 */
	public DatumZeitDialog(final Shell parentShell, final long initialValue) {
		super(parentShell, initialValue);
	}

	/**
	 * Konstruktor mit absolutem Datenverteiler- {@link TimeAttributeType}.
	 *
	 * @param parentShell
	 *            Eltern-shell
	 * @param initialData
	 *            Initialwert für das {@link DatumZeit}-Widget.
	 */
	public DatumZeitDialog(final Shell parentShell, final Data initialData) {
		super(parentShell, initialData);
		final TimeAttributeType attrType = (TimeAttributeType) initialData
				.getAttributeType();
		Assert.isTrue(!attrType.isRelative());
	}

	@Override
	protected Control createDialogArea(final Composite parent) {
		parent.getShell().setText("Auswahl des Zeitpunktes");
		parent.getShell().setImage(
				parent.getDisplay().getSystemImage(SWT.ICON_QUESTION));
		setTitle("Auswahl eines absoluten Zeitpunktes");
		StringBuilder neueMessage = new StringBuilder("Auswahl eines absoluten Zeitpunktes, ").append(genauigkeitMillis ? "milli" : "").append("sekundengenau");
		if (null != attributName) {
			neueMessage.append(",\nfür Attribut '").append(attributName).append("'");
		}
		setMessage(neueMessage.toString(), IMessageProvider.INFORMATION);

		GridData gd;
		final Composite panel = new Composite(parent, SWT.NONE);
		final GridLayout gl = new GridLayout();
		gl.numColumns = 2;
		gl.marginLeft = 40;
		gl.marginRight = 0;
		gl.verticalSpacing = 10;
		panel.setLayout(gl);
		gd = new GridData(GridData.FILL_HORIZONTAL);
		gd.widthHint = 60;
		panel.setLayoutData(gd);

		final Label labelDatum = new Label(panel, SWT.NONE);
		labelDatum.setText("Zeitpunkt:");
		gd = new GridData(SWT.LEFT, SWT.TOP, false, false);
		gd.horizontalSpan = 1;
		gd.horizontalAlignment = SWT.LEFT;
		labelDatum.setLayoutData(gd);

		final DatumZeit.Eingabetyp eingabeTyp = genauigkeitMillis
				? DatumZeit.Eingabetyp.datumuhrMS
				: DatumZeit.Eingabetyp.datumuhr;
		datumZeit = new DatumZeit(panel, SWT.NONE, eingabeTyp, true, true);
		datumZeit.setToolTipText("Datum und Uhrzeit");
		datumZeit.setLayout(new GridLayout());
		datumZeit.setDatum(new Date(initialValue));
		gd = new GridData(SWT.LEFT, SWT.TOP, true, false);
		gd.horizontalSpan = 1;
		gd.horizontalAlignment = SWT.RIGHT;
		datumZeit.setLayoutData(gd);
		return panel;
	}

	@Override
	protected void okPressed() {
		selectedValue = datumZeit.getDatum().getTime();
		super.okPressed();
	}

}
