/*
 * Rahmenwerk-Plug-in "BitCtrl-Bibliotheken"
 *
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
/* Copyright by BitCtrl Systems Leipzig */
/* BitCtrl Systems Leipzig */
/* Weisenfelser Str. 67 */
/* 04229 Leipzig */
/* Tel.: +49 341 49067 - 0 */
/* Fax.: +49 341 49067 - 15 */
/* mailto:info@bitctrl.de */
/* http://www.bitctrl.de */
/*---------------------------------------------------------------*/
package de.bsvrz.buv.rw.bitctrl.eclipse.wizards;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.widgets.Shell;

import de.bsvrz.buv.rw.basislib.kalender.CompositeZeitDauer;
import de.bsvrz.dav.daf.main.Data;
import de.bsvrz.dav.daf.main.config.TimeAttributeType;

/**
 * Dialogvorlage für die Auswahl eines Zeitpunktes (absolut oder relativ).
 *
 * @author BitCtrl Systems GmbH, Albrecht Uhlmann
 *
 */
public abstract class ZeitAuswahlDialog extends TitleAreaDialog {

	/**
	 * Initialwert in Millisekunden
	 */
	protected final long initialValue;

	/**
	 * vom Nutzer selektierter Wert, in Millisekunden
	 */
	protected long selectedValue;

	/**
	 * true - Genauigkeit in Millisekunden, false - Genauigkeit in Sekunden
	 */
	protected final boolean genauigkeitMillis;

	/**
	 * Name des bearbeiteten Attributs, falls der Dialog mit einem {@link Data}
	 * -Objekt initialisiert wurde, ansonsten <code>null</code>
	 */
	protected final String attributName;

	/**
	 * Konstruktor mit üblichem long-Wert (muss >= 0 sein) - Millisekunden
	 *
	 * @param parentShell
	 *            Eltern-shell
	 * @param initialValue
	 *            Initialwert für das {@link CompositeZeitDauer}-Widget.
	 */
	public ZeitAuswahlDialog(final Shell parentShell, final long initialValue) {
		super(parentShell);
		this.initialValue = initialValue;
		genauigkeitMillis = true;
		Assert.isTrue(initialValue >= 0);
		attributName = null;
	}

	/**
	 * Konstruktor mit Datenverteiler- {@link TimeAttributeType}. Ob dieser
	 * relativ und/oder absolut sein darf/muss, entscheidet die implementierende
	 * Klasse.
	 *
	 * @param parentShell
	 *            Eltern-shell
	 * @param initialData
	 *            Initialwert für das {@link CompositeZeitDauer}-Widget.
	 */
	public ZeitAuswahlDialog(final Shell parentShell, final Data initialData) {
		super(parentShell);
		Assert.isNotNull(initialData);
		Assert.isTrue(initialData.isPlain());
		Assert.isTrue(
				initialData.getAttributeType() instanceof TimeAttributeType);
		final TimeAttributeType attrType = (TimeAttributeType) initialData
				.getAttributeType();
		initialValue = initialData.asTimeValue().getMillis();
		genauigkeitMillis = TimeAttributeType.MILLISECONDS == attrType
				.getAccuracy();
		attributName = initialData.getName();
	}

	/**
	 * Liefert den vom Nutzer ausgewählten Wert, in Millisekunden
	 *
	 * @return der Wert
	 */
	public long getSelectedValue() {
		return selectedValue;
	}

}