/*
 * Rahmenwerk-Plug-in "BitCtrl-Bibliotheken"
 *
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.rw;

import de.bsvrz.buv.rw.basislib.Rahmenwerk;
import de.bsvrz.buv.rw.basislib.dav.DavVerbindungsEvent;
import de.bsvrz.buv.rw.basislib.dav.DavVerbindungsListener;
import de.bsvrz.sys.funclib.bitctrl.modell.DefaultObjektFactory;
import de.bsvrz.sys.funclib.bitctrl.modell.ObjektFactory;

/**
 * Eine {@link ObjektFactory} als OSGI-Service, die die Rahmenverwerksverbindung
 * zur Kommunikation mit dem Datenverteiler verwendet.
 *
 * @author BitCtrl Systems GmbH, Falko Schumann
 *
 */
public class NutzerverbindungObjektFactory extends DefaultObjektFactory {

	private final DavVerbindungsListener davVerbindungZuhoerer = new DavVerbindungsListener() {

		@Override
		public void verbindungHergestellt(final DavVerbindungsEvent event) {
			setDav(event.getDavVerbindung());
		}

		@Override
		public void verbindungGetrennt(final DavVerbindungsEvent event) {
			setVerbunden(false);
		}

		@Override
		public boolean verbindungHalten(final DavVerbindungsEvent event) {
			return false;
		}

	};
	private Rahmenwerk rahmenwerk;

	/**
	 * Setzt den Namen der Verbindung auf "Nutzerverbindung".
	 */
	public NutzerverbindungObjektFactory() {
		super("Nutzerverbindung", null);
	}

	/**
	 * Aktiviert den Service.
	 *
	 */
	protected void activate() {
		rahmenwerk.addDavVerbindungsListener(davVerbindungZuhoerer);
		if (rahmenwerk.isOnline()) {
			setDav(rahmenwerk.getDavVerbindung());
		}
	}

	/**
	 * Deaktiviert den Service.
	 *
	 * @param context
	 */
	protected void deactivate() {
		setVerbunden(false);
		rahmenwerk.removeDavVerbindungsListener(davVerbindungZuhoerer);
	}

	protected void bindRahmenwerk(final Rahmenwerk newRahmenwerk) {
		rahmenwerk = newRahmenwerk;
	}

	protected void unbindRahmenwerk(final Rahmenwerk oldRahmenwerk) {
		rahmenwerk = null;
	}

	public Rahmenwerk getRahmenwerk() {
		return rahmenwerk;
	}
}
