/*
 * Rahmenwerk-Plug-in "BitCtrl-Bibliotheken"
 *
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.util.cache.ui.internal;

import java.util.List;

import org.eclipse.core.runtime.Platform;

import de.bsvrz.buv.rw.basislib.Rahmenwerk;
import de.bsvrz.buv.rw.bitctrl.CacheService;
import de.bsvrz.sys.funclib.bitctrl.modell.ObjektFactory;
import de.bsvrz.sys.funclib.bitctrl.modell.SystemObjekt;
import de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.VerkehrsModellNetz;
import de.bsvrz.sys.funclib.bitctrl.modell.util.cache.AnzeigeVerfahrenCache;
import de.bsvrz.sys.funclib.bitctrl.modell.util.cache.AnzeigenCache;
import de.bsvrz.sys.funclib.bitctrl.modell.util.cache.AqCache;
import de.bsvrz.sys.funclib.bitctrl.modell.util.cache.MifCache;
import de.bsvrz.sys.funclib.bitctrl.modell.util.cache.ModellObjektCache;
import de.bsvrz.sys.funclib.bitctrl.modell.util.cache.MqCache;
import de.bsvrz.sys.funclib.bitctrl.modell.util.cache.NetzCache;
import de.bsvrz.sys.funclib.bitctrl.modell.util.cache.NetzCacheExtended;
import de.bsvrz.sys.funclib.bitctrl.modell.util.cache.RdsCache;
import de.bsvrz.sys.funclib.bitctrl.modell.util.cache.RdsMeldungenCache;
import de.bsvrz.sys.funclib.bitctrl.modell.util.cache.StrassenTeilSegmenteCache;
import de.bsvrz.sys.funclib.bitctrl.modell.util.cache.StreckenAbschnittCache;
import de.bsvrz.sys.funclib.bitctrl.modell.util.cache.TmcCache;
import de.bsvrz.sys.funclib.bitctrl.modell.util.cache.TmcLocationCodeCache;

/**
 * @author BitCtrl Systems GmbH 2013, Christian Hösel
 *
 */
public class CacheServiceImpl implements CacheService {

	private static final String VERKEHRS_MODELL_OBJEKT = "-verkehrsModellObjekt";
	private Rahmenwerk rahmenWerk;
	private String defaultNetzPid;
	private ObjektFactory objektFactory;
	private static CacheServiceImpl service;

	/**
	 * liefert die globale Instanz der Komponente.
	 *
	 * @return die Komponente
	 */
	public static CacheServiceImpl getService() {
		return CacheServiceImpl.service;
	}

	/** aktiviert die Komponente. */
	protected void activate() {
		CacheServiceImpl.service = this;
	}

	/** deaktiviert die Komponente. */
	protected void deactivate() {
		CacheServiceImpl.service = null;
	}

	public Rahmenwerk getRahmenWerk() {
		return rahmenWerk;
	}

	/**
	 * bindet einen Rahmenwerk-Service an die Komponente.
	 *
	 * @param newRahmenWerk
	 *            der Service
	 */
	protected void bindRahmenwerk(final Rahmenwerk newRahmenWerk) {
		rahmenWerk = newRahmenWerk;
	}

	/**
	 * entfernt einen Rahmenwerk-Service von der Komponente.
	 *
	 * @param newRahmenWerk
	 *            der Service
	 */
	protected void unbindRahmenwerk(final Rahmenwerk newRahmenWerk) {
		rahmenWerk = null;
	}

	@Override
	public ModellObjektCache getModellObjektCache(final String netz) {
		return getCache(netz, ModellObjektCache.class);
	}

	@Override
	public NetzCache getNetzCache(final String netz) {
		return getCache(netz, NetzCache.class);
	}

	@Override
	public NetzCacheExtended getNetzCacheExtended(final String netz) {
		return getCache(netz, NetzCacheExtended.class);
	}

	@Override
	public TmcCache getTmcCache(final String netz) {
		return getCache(netz, TmcCache.class);
	}

	@Override
	public MqCache getMqCache(final String netz) {
		return getCache(netz, MqCache.class);
	}

	@Override
	public MifCache getMifCache() {
		return getCache(MifCache.class.getName(), MifCache.class);
	}

	@Override
	public AnzeigeVerfahrenCache getAnzeigeVerfahrenCache() {
		return getCache(AnzeigeVerfahrenCache.class.getName(),
				AnzeigeVerfahrenCache.class);
	}

	@Override
	public AqCache getAqCache(final String netz) {
		return getCache(netz, AqCache.class);
	}

	@Override
	public AnzeigenCache getAnzeigenCache() {
		return getCache(AnzeigenCache.class.getName(), AnzeigenCache.class);
	}

	@Override
	public StrassenTeilSegmenteCache getStrassenTeilSegmenteCache(
			final String netz) {
		return getCache(netz, StrassenTeilSegmenteCache.class);
	}

	@Override
	public StreckenAbschnittCache getStreckenAbschnittCache(final String netz) {
		return getCache(netz, StreckenAbschnittCache.class);
	}

	@Override
	public RdsCache getRdsCache() {
		return getCache(RdsCache.class.getName(), RdsCache.class);
	}

	@Override
	public TmcLocationCodeCache getTmcLocationCodeCache() {
		return getCache(TmcLocationCodeCache.class.getName(),
				TmcLocationCodeCache.class);
	}

	@Override
	public RdsMeldungenCache getRdsMeldungenCache(final String lms) {
		return getCache(lms, RdsMeldungenCache.class);
	}

	private <T> T getCache(final String base, final Class<T> t) {
		return Platform.getAdapterManager().getAdapter(base, t);
	}

	protected void bindObjektFactory(final ObjektFactory newObjektFactory) {
		objektFactory = newObjektFactory;
	}

	protected void unbindObjektFactory(final ObjektFactory newObjektFaktory) {
		objektFactory = null;
	}

	@Override
	public String getDefaultNetzPid() {
		if (defaultNetzPid == null) {
			if (rahmenWerk.getStartParameter()
					.hasArgument(VERKEHRS_MODELL_OBJEKT)) {
				defaultNetzPid = rahmenWerk.getStartParameter()
						.fetchArgument(VERKEHRS_MODELL_OBJEKT).asString();
			}
			if (defaultNetzPid == null && (objektFactory != null)
					&& objektFactory.isVerbunden()) {
				final List<? extends SystemObjekt> verkehrsmodellListe = objektFactory
						.bestimmeModellobjekte(VerkehrsModellNetz.PID);
				if (verkehrsmodellListe.size() == 1) {
					defaultNetzPid = verkehrsmodellListe.iterator().next()
							.getPid();
				} else {
					throw new IllegalStateException(
							"Es sind mehrere VerkehrsModellNetz-Objekte in der Konfiguration und es wurde kein konkretes für die Verwendung im Rahmenwerk angegeben!");
				}
			}
		}
		if (defaultNetzPid == null) {
			throw new IllegalStateException(
					"Es konnte kein Standard-VerkehrsModellNetz-Objekt ermittelt werden!");
		}
		return defaultNetzPid;
	}

}
