/*
 * Rahmenwerk-Plug-in "BitCtrl-Bibliotheken"
 *
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.sys.funclib.bitctrl.modell.util.cache.ui.internal;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ui.progress.UIJob;

import de.bsvrz.buv.rw.basislib.Rahmenwerk;

public abstract class EclipseCacheJob extends Job {

	private static final class BlockRule implements ISchedulingRule {

		@Override
		public boolean contains(final ISchedulingRule rule) {
			return rule == this;
		}

		@Override
		public boolean isConflicting(final ISchedulingRule rule) {
			return rule == this;
		}
	}

	/**
	 * Eine gemeinsame Regel für alle Cache - Jobs. Damit sollten jetzt keine 2
	 * Caches mehr gleichzeitig initialisiert werden können.
	 */
	private static final ISchedulingRule rule = new BlockRule();

	public EclipseCacheJob(final String name) {
		super(name);

		final UIJob uijob = new UIJob("Wait for UI") {
			@Override
			public IStatus runInUIThread(final IProgressMonitor monitor) {
				return Status.OK_STATUS;
			}
		};
		uijob.setRule(rule);
		uijob.schedule();

		setRule(rule);
		setPriority(Job.LONG);
	}

	@Override
	public boolean belongsTo(final Object family) {
		// TODO Blockiert unter Umständen das Beenden, wenn eine
		// Datenverteilerverbindung neu aufgebaut wurde
		if (Rahmenwerk.JOB_FAMILY.equals(family)) {
			return true;
		}
		return super.belongsTo(family);
	}
}
