/*
 * Rahmenwerk-Plug-in "BitCtrl-Bibliotheken"
 *
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.util.cache.ui.internal;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

import com.bitctrl.util.monitor.IMonitor;

import de.bsvrz.buv.rw.bitctrl.internal.RahmenwerkService;
import de.bsvrz.dav.daf.main.ClientDavInterface;
import de.bsvrz.sys.funclib.bitctrl.daf.DavProvider;
import de.bsvrz.sys.funclib.bitctrl.modell.ObjektFactory;
import de.bsvrz.sys.funclib.bitctrl.modell.util.cache.AbstractDavVerbindungsCache;

public final class EclipseDavVerbindungsCache
		extends AbstractDavVerbindungsCache implements PropertyChangeListener {

	private Object threadSync;

	protected void preInit() {
		threadSync = new Object();
	}

	@Override
	protected void callDoInit(final IMonitor monitor) {
		synchronized (threadSync) {
			final Thread thread = new Thread() {
				@Override
				public void run() {
					synchronized (threadSync) {
						EclipseDavVerbindungsCache.super.callDoInit(monitor);
					}
				}
			};
			thread.setDaemon(true);
			thread.start();
		}
	}

	@Override
	protected boolean doInit(final IMonitor monitor) {
		ObjektFactory addedNV = null;
		while (true) {
			synchronized (threadSync) {
				final ObjektFactory nutzerverbindung = RahmenwerkService
						.getService().getObjektFactory();
				if (null != nutzerverbindung
						&& !nutzerverbindung.equals(addedNV)) {
					if (null != addedNV) {
						addedNV.removePropertyChangeListener(
								DavProvider.PROP_VERBUNDEN, this);
					}
					nutzerverbindung.addPropertyChangeListener(
							DavProvider.PROP_VERBUNDEN, this);
					addedNV = nutzerverbindung;
				}
				if (null != nutzerverbindung
						&& nutzerverbindung.isVerbunden()) {
					return true;
				}
			}
			try {
				Thread.sleep(100);
			} catch (final InterruptedException e) {
				e.printStackTrace();
			}
		}
	}

	@Override
	public ClientDavInterface getClientDavInterface() {
		ensureInit();
		return RahmenwerkService.getService().getObjektFactory().getDav();
	}

	@Override
	public ObjektFactory getObjektFactory() {
		ensureInit();
		return RahmenwerkService.getService().getObjektFactory();
	}

	@Override
	public void propertyChange(final PropertyChangeEvent evt) {
		synchronized (threadSync) {
			final ObjektFactory nutzerverbindung = RahmenwerkService
					.getService().getObjektFactory();
			if ((null == nutzerverbindung)
					|| (!nutzerverbindung.isVerbunden())) {
				setState(PROP_STATE_CANCELED);
			} else if (nutzerverbindung.isVerbunden()) {
				redoInit();
			}
		}
	}
}