/*
 * Rahmenwerk-Plug-in "BitCtrl-Bibliotheken"
 *
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.sys.funclib.bitctrl.modell.util.cache.ui.internal;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

import com.bitctrl.lib.eclipse.util.monitor.EclipseMonitor;
import com.bitctrl.util.monitor.IMonitor;

import de.bsvrz.sys.funclib.bitctrl.modell.util.cache.AbstractDavVerbindungsCache;
import de.bsvrz.sys.funclib.bitctrl.modell.util.cache.TmcLocationCodeCache;

public class EclipseTmcLocationCodeCache extends TmcLocationCodeCache {

	/**
	 * Der Konstruktor.
	 *
	 * @param netzCache
	 *            der Netz-Cache, von dem dieser Cache abhängig ist
	 *
	 */
	public EclipseTmcLocationCodeCache(
			final AbstractDavVerbindungsCache verbindungsCache) {
		super(verbindungsCache);
	}

	@Override
	protected void callDoInit(final IMonitor monitor) {
		final Job job = new EclipseCacheJob(
				"Erzeuge TMC-LocationCode-Cache: " + getName()) {
			@Override
			protected IStatus run(final IProgressMonitor monitor) {
				EclipseTmcLocationCodeCache.super.callDoInit(
						new EclipseMonitor(monitor));
				return Status.OK_STATUS;
			}
		};
		job.schedule();
	}
}
