/*
 * Rahmenwerk-Plug-in "BitCtrl-Bibliotheken"
 *
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.sys.funclib.bitctrl.modell.util.cache.ui.internal;

import org.eclipse.core.runtime.IAdapterFactory;

import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.sys.funclib.bitctrl.modell.SystemObjekt;
import de.bsvrz.sys.funclib.bitctrl.modell.util.rdstmc.RdsMeldungWrapper;

/**
 * Adapter-Factory, welche zu einem RdsMeldungWrapper das passende SystemObjekt
 * bzw. SystemObject zurückliefern kann.
 *
 * @author BitCtrl Systems GmbH, Andreas Meissner
 *
 */
public class RdsMeldungWrapperAdapterFactory implements IAdapterFactory {

	@Override
	public Object getAdapter(final Object adaptableObject,
			final Class adapterType) {

		if (adaptableObject instanceof final RdsMeldungWrapper wrapper) {
			final SystemObjekt rdsMeldung = wrapper.getRdsMeldung();
			if (adapterType == SystemObjekt.class) {
				return rdsMeldung;
			} else if (adapterType == SystemObject.class
					&& rdsMeldung != null) {
				return rdsMeldung.getSystemObject();
			}
		}
		return null;
	}

	@Override
	public Class[] getAdapterList() {
		return new Class[] { SystemObjekt.class, SystemObject.class };
	}
}
