/*
 * Rahmenwerk-Plug-in "BitCtrl-Bibliotheken"
 *
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.rw;

import de.bsvrz.buv.rw.basislib.Rahmenwerk;
import de.bsvrz.buv.rw.basislib.dav.DavVerbindungsEvent;
import de.bsvrz.buv.rw.basislib.dav.DavVerbindungsListener;
import de.bsvrz.sys.funclib.bitctrl.daf.DavProvider;
import de.bsvrz.sys.funclib.bitctrl.daf.DefaultDavProvider;

/**
 * Ein {@link DavProvider} als OSGI-Service, der die Rahmenverwerksverbindung
 * veröffentlicht.
 *
 * @author BitCtrl Systems GmbH, Falko Schumann
 *
 *
 * @deprecated wird nicht verwendet, Funktionalität wird durch entsprechende
 *             Rahmenwerksfunktionen bereitgestellt.
 **/
@Deprecated
public class RahmenwerkDavProvider extends DefaultDavProvider {

	private Rahmenwerk rahmenwerk;
	private final DavVerbindungsListener davVerbindungZuhoerer = new DavVerbindungsListener() {

		@Override
		public void verbindungHergestellt(final DavVerbindungsEvent event) {
			setDav(event.getDavVerbindung());
		}

		@Override
		public boolean verbindungHalten(final DavVerbindungsEvent event) {
			return false;
		}

		@Override
		public void verbindungGetrennt(final DavVerbindungsEvent event) {
			setVerbunden(false);
		}
	};

	/**
	 * Setzt den Namen der Verbindung auf "Nutzerverbindung".
	 */
	public RahmenwerkDavProvider() {
		super("Nutzerverbindung", null);
	}

	/**
	 * Aktiviert den Service.
	 *
	 */
	protected void activate() {
		rahmenwerk.addDavVerbindungsListener(davVerbindungZuhoerer);
		if (rahmenwerk.isOnline()) {
			setDav(rahmenwerk.getDavVerbindung());
		}
	}

	/**
	 * Deaktiviert den Service.
	 *
	 */
	protected void deactivate() {
		if (rahmenwerk != null) {
			rahmenwerk.removeDavVerbindungsListener(davVerbindungZuhoerer);
		}
		setVerbunden(false);
	}

	protected void bindRahmenwerk(final Rahmenwerk newRahmenwerk) {
		rahmenwerk = newRahmenwerk;
	}

	protected void unbindRahmenwerk(
			@SuppressWarnings("unused") final Rahmenwerk oldRahmenwerk) {
		rahmenwerk = null;
	}
}
