/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.rw.bitctrl.eclipse;

import de.bsvrz.buv.rw.bitctrl.internal.BitCtrlRahmenwerkPlugin;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.dav.daf.main.config.SystemObjectType;
import de.bsvrz.sys.funclib.bitctrl.modell.SystemObjekt;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public final class SystemObjectTypeLabelProvider
extends LabelProvider {
    private final Map<SystemObject, Image> typeMap = new HashMap<SystemObject, Image>();
    private final boolean useNameForText;

    public SystemObjectTypeLabelProvider() {
        this(false);
    }

    public SystemObjectTypeLabelProvider(boolean useNameForText) {
        this.useNameForText = useNameForText;
    }

    public Image getImage(Object element) {
        SystemObject so = this.getSystemObject(element);
        Object type = so instanceof SystemObjectType ? (SystemObjectType)so : so.getType();
        Image image = this.typeMap.get(type);
        if (image == null) {
            ImageDescriptor imageDescriptor = null;
            while (imageDescriptor == null && type != null) {
                String iconBase = "icons/" + type.getPid();
                imageDescriptor = BitCtrlRahmenwerkPlugin.getDefault().getImageDescriptor(iconBase + ".png");
                if (imageDescriptor == null) {
                    imageDescriptor = BitCtrlRahmenwerkPlugin.getDefault().getImageDescriptor(iconBase + ".gif");
                }
                if (imageDescriptor != null) continue;
                List superTypes = type.getSuperTypes();
                type = 1 == superTypes.size() ? (SystemObjectType)superTypes.get(0) : null;
            }
            if (imageDescriptor != null) {
                image = imageDescriptor.createImage();
            }
            this.typeMap.put((SystemObject)so.getType(), image);
        }
        return image;
    }

    public String getText(Object element) {
        if (this.useNameForText) {
            return this.getSystemObject(element).getName();
        }
        return super.getText(element);
    }

    private SystemObject getSystemObject(Object element) {
        if (element instanceof SystemObjekt) {
            return ((SystemObjekt)element).getSystemObject();
        }
        return (SystemObject)element;
    }

    public void dispose() {
        Iterator<Map.Entry<SystemObject, Image>> it = this.typeMap.entrySet().iterator();
        while (it.hasNext()) {
            Image image = it.next().getValue();
            if (image != null) {
                image.dispose();
            }
            it.remove();
        }
        super.dispose();
    }
}

