/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.rw.bitctrl.eclipse.databinding;

import de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsTMCRichtung;
import de.bsvrz.sys.funclib.bitctrl.modell.tmtmcglobal.attribute.AttTmcRichtung;
import de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.Strasse;
import de.bsvrz.sys.funclib.bitctrl.modell.util.cache.NetzCache;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.progress.UIJob;

public class RichtungTextComputedValue
extends ComputedValue {
    public static final String DEFAULT_TEXT_NEGATIVE_RICHTUNG = "negativ (Gegenrichtung)";
    public static final String DEFAULT_TEXT_POSITIVE_RICHTUNG = "positiv (Fahrtrichtung)";
    private final IObservableValue strasseObservable;
    private final AttTmcRichtung richtung;
    private final String defaultText;
    private final Display display;
    private final Composite composite;
    private final NetzCache netzCache;

    public RichtungTextComputedValue(NetzCache netzCache, IObservableValue strasseObservable, AttTmcRichtung richtung, Composite composite, Display display) {
        assert (netzCache != null);
        assert (strasseObservable != null);
        assert (richtung != null);
        this.display = display;
        this.composite = composite;
        this.netzCache = netzCache;
        this.strasseObservable = strasseObservable;
        this.richtung = richtung;
        this.defaultText = richtung == AttTmcRichtung.ZUSTAND_1_POSITIV ? DEFAULT_TEXT_POSITIVE_RICHTUNG : DEFAULT_TEXT_NEGATIVE_RICHTUNG;
    }

    public RichtungTextComputedValue(NetzCache netzCache, IObservableValue strasseObservable, AttRdsTMCRichtung richtung, Composite composite, Display display) {
        this(netzCache, strasseObservable, richtung == AttRdsTMCRichtung.ZUSTAND_0_POSITIV ? AttTmcRichtung.ZUSTAND_1_POSITIV : AttTmcRichtung.ZUSTAND_1N_NEGATIV, composite, display);
    }

    protected Object calculate() {
        Strasse strasse = (Strasse)this.strasseObservable.getValue();
        String richtungText = RichtungTextComputedValue.getRichtungText(this.netzCache, strasse, this.richtung);
        if (this.composite != null && this.display != null) {
            UIJob job = new UIJob(this.display, "Aktualisiere Radio-Buttons"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    RichtungTextComputedValue.this.composite.layout(true, true);
                    return Status.OK_STATUS;
                }
            };
            job.schedule(1L);
        }
        if (richtungText != null) {
            return richtungText;
        }
        return this.defaultText;
    }

    public static String getRichtungText(NetzCache netzCache, Strasse strasse, AttTmcRichtung richtung) {
        String vonStrassenKnoten = netzCache.getVonStrassenKnoten(strasse, richtung);
        String nachStrassenKnoten = netzCache.getNachStrassenKnoten(strasse, richtung);
        if (vonStrassenKnoten != null && nachStrassenKnoten != null) {
            return new StringBuffer("von ").append(vonStrassenKnoten).append(" nach ").append(nachStrassenKnoten).toString();
        }
        return null;
    }

    public static String getRichtungText(NetzCache netzCache, Strasse strasse, AttRdsTMCRichtung richtung) {
        return RichtungTextComputedValue.getRichtungText(netzCache, strasse, richtung == AttRdsTMCRichtung.ZUSTAND_0_POSITIV ? AttTmcRichtung.ZUSTAND_1_POSITIV : AttTmcRichtung.ZUSTAND_1N_NEGATIV);
    }
}

