/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.rw.bitctrl.eclipse.dialogs;

import de.bsvrz.buv.rw.bitctrl.eclipse.dialogs.SystemObjectTreeContentProvider;
import de.bsvrz.dav.daf.main.ClientDavInterface;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.dav.daf.main.config.SystemObjectType;
import de.bsvrz.sys.funclib.bitctrl.util.SystemObjectComparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.CheckedTreeSelectionDialog;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.eclipse.ui.dialogs.SelectionDialog;

public final class SystemObjectSelectionDialog {
    public static final String NO_SELECTION = "<Keine Auswahl>";

    public static SelectionDialog createListSelectionDialog(Shell parent, SystemObjectType systemObjectType, int style) {
        Assert.isLegal(((style & 4) == 4 || (style & 2) == 2 || (style & 0x80) == 128 ? 1 : 0) != 0);
        boolean multipleSelection = (style & 2) == 2;
        boolean noSelection = (style & 0x80) == 128;
        ArrayList<String> objects = new ArrayList<String>(systemObjectType.getObjects());
        Collections.sort(objects, new SystemObjectComparator());
        if (noSelection) {
            objects.add(0, NO_SELECTION);
        }
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(parent, (ILabelProvider)new LabelProvider());
        dialog.setMultipleSelection(multipleSelection);
        dialog.setElements(objects.toArray());
        SystemObjectSelectionDialog.init((SelectionDialog)dialog, systemObjectType, multipleSelection);
        return dialog;
    }

    public static SelectionDialog createMultiSelectionDialog(Shell parent, SystemObjectType systemObjectType) {
        ArrayList objects = new ArrayList(systemObjectType.getObjects());
        Collections.sort(objects, new SystemObjectComparator());
        ListSelectionDialog dialog = new ListSelectionDialog(parent, objects, (IStructuredContentProvider)new ArrayContentProvider(), (ILabelProvider)new LabelProvider(), null);
        SystemObjectSelectionDialog.init((SelectionDialog)dialog, systemObjectType, true);
        return dialog;
    }

    public static SelectionDialog createTreeSelectionDialog(Shell parent, SystemObjectType systemObjectType, int style) {
        Assert.isLegal((style == 4 || style == 2 ? 1 : 0) != 0);
        boolean multipleSelection = style == 2;
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(parent, (ILabelProvider)new LabelProvider(), (ITreeContentProvider)new SystemObjectTreeContentProvider());
        dialog.setAllowMultiple(multipleSelection);
        dialog.setInput((Object)systemObjectType);
        SystemObjectSelectionDialog.init((SelectionDialog)dialog, systemObjectType, multipleSelection);
        return dialog;
    }

    public static SelectionDialog createTreeSelectionDialog(Shell parent, ClientDavInterface dav) {
        CheckedTreeSelectionDialog dialog = new CheckedTreeSelectionDialog(parent, (ILabelProvider)new LabelProvider(), (ITreeContentProvider)new SystemObjectTreeContentProvider());
        dialog.setInput((Object)dav);
        SystemObjectSelectionDialog.init((SelectionDialog)dialog, null, true);
        return dialog;
    }

    public static void init(SelectionDialog dialog, SystemObjectType systemObjectType, boolean multipleSelection) {
        Object message;
        String title;
        if (multipleSelection) {
            title = "Systemobjekte ausw\u00e4hlen";
            message = "Bitte w\u00e4hlen Sie ein oder mehrere Systemobjekte";
            if (systemObjectType != null) {
                message = (String)message + " vom Typ" + String.valueOf(systemObjectType);
            }
            message = (String)message + " aus.";
        } else {
            title = "Systemobjekt ausw\u00e4hlen";
            message = "Bitte w\u00e4hlen Sie ein Systemobjekt";
            if (systemObjectType != null) {
                message = (String)message + " vom Typ" + String.valueOf(systemObjectType);
            }
            message = (String)message + " aus.";
        }
        dialog.setTitle(title);
        dialog.setMessage((String)message);
    }

    public static SystemObject getFirstSelectedObject(SelectionDialog dialog) {
        Object[] result = dialog.getResult();
        if (result != null) {
            if (result[0].equals(NO_SELECTION)) {
                return null;
            }
            return (SystemObject)result[0];
        }
        return null;
    }

    public static List<SystemObject> getSelectedObjects(SelectionDialog dialog) {
        Object[] dialogResult = dialog.getResult();
        if (dialogResult != null) {
            ArrayList<SystemObject> result = new ArrayList<SystemObject>();
            Object[] objectArray = dialogResult;
            int n = dialogResult.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                if (o instanceof SystemObject) {
                    result.add((SystemObject)o);
                }
                ++n2;
            }
            return result;
        }
        return Collections.emptyList();
    }

    private SystemObjectSelectionDialog() {
    }
}

