/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.rw.bitctrl.eclipse.internal;

import de.bsvrz.buv.rw.basislib.Rahmenwerk;
import de.bsvrz.buv.rw.basislib.dav.DavVerbindungsEvent;
import de.bsvrz.buv.rw.basislib.dav.DavVerbindungsListener;
import de.bsvrz.buv.rw.bitctrl.internal.RahmenwerkService;
import de.bsvrz.sys.funclib.bitctrl.modell.ObjektFactory;
import de.bsvrz.sys.funclib.bitctrl.modell.util.benutzer.Benutzerverwaltung;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.ui.AbstractSourceProvider;

public class SourceProvider
extends AbstractSourceProvider
implements DavVerbindungsListener {
    private final Map<Object, Object> currentState = new HashMap<Object, Object>();

    public SourceProvider() {
        this.currentState.put("de.bsvrz.buv.rw.bitctrl.eclipse.variable.isDavVerbunden", RahmenwerkService.getService().getRahmenWerk().isOnline());
        this.updateIsAdmin();
        RahmenwerkService.getService().getRahmenWerk().addDavVerbindungsListener((DavVerbindungsListener)this);
    }

    public Map<Object, Object> getCurrentState() {
        return this.currentState;
    }

    public String[] getProvidedSourceNames() {
        return new String[]{"de.bsvrz.buv.rw.bitctrl.eclipse.variable.isAktuellerBenutzerAdmin"};
    }

    public void dispose() {
        RahmenwerkService.getService().getRahmenWerk().removeDavVerbindungsListener((DavVerbindungsListener)this);
    }

    private void updateIsAdmin() {
        ObjektFactory objektFactory = RahmenwerkService.getService().getObjektFactory();
        Rahmenwerk rahmenwerk = RahmenwerkService.getService().getRahmenWerk();
        if (objektFactory.isVerbunden() && rahmenwerk.isOnline()) {
            String benutzer = rahmenwerk.getBenutzerName();
            String passwort = rahmenwerk.getPasswort();
            Benutzerverwaltung benutzerverwaltung = new Benutzerverwaltung(objektFactory);
            this.currentState.put("de.bsvrz.buv.rw.bitctrl.eclipse.variable.isAktuellerBenutzerAdmin", benutzerverwaltung.isDAVAdmin(benutzer, passwort));
        } else {
            this.currentState.put("de.bsvrz.buv.rw.bitctrl.eclipse.variable.isAktuellerBenutzerAdmin", true);
        }
    }

    public void verbindungHergestellt(DavVerbindungsEvent event) {
        this.currentState.put("de.bsvrz.buv.rw.bitctrl.eclipse.variable.isDavVerbunden", true);
        this.updateIsAdmin();
    }

    public void verbindungGetrennt(DavVerbindungsEvent event) {
        this.currentState.put("de.bsvrz.buv.rw.bitctrl.eclipse.variable.isDavVerbunden", false);
        this.updateIsAdmin();
    }

    public boolean verbindungHalten(DavVerbindungsEvent event) {
        return false;
    }
}

