/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.rw.bitctrl.eclipse.modell;

import com.bitctrl.lib.eclipse.actions.RefreshViewerAction;
import com.bitctrl.lib.eclipse.emf.viewers.EmfLabelProvider;
import de.bsvrz.buv.rw.bitctrl.eclipse.viewers.EinstellungenContentProvider;
import de.bsvrz.buv.rw.bitctrl.internal.RahmenwerkService;
import de.bsvrz.sys.funclib.bitctrl.daf.DavProvider;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.ViewPart;

public abstract class AbstractEinstellungenView
extends ViewPart {
    private VerbundenPropertyChangeListener verbundenPropertyChangeListener;
    private DavProvider davProvider;
    private boolean online;
    private TreeViewer viewer;
    private MenuManager contextMenu;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.davProvider = RahmenwerkService.getService().getObjektFactory();
        this.online = this.davProvider.isVerbunden();
        this.verbundenPropertyChangeListener = new VerbundenPropertyChangeListener();
        this.davProvider.addPropertyChangeListener("verbunden", (PropertyChangeListener)this.verbundenPropertyChangeListener);
    }

    public final void createPartControl(Composite parent) {
        this.viewer = new TreeViewer(parent, 2050);
        this.viewer.setContentProvider((IContentProvider)new EinstellungenContentProvider());
        EmfLabelProvider labelProvider = new EmfLabelProvider();
        ILabelDecorator decorator = PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator();
        this.viewer.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)labelProvider, decorator));
        this.getViewSite().getActionBars().setGlobalActionHandler(ActionFactory.REFRESH.getCommandId(), (IAction)new RefreshViewerAction((Viewer)this.viewer));
        this.configureViewer(this.viewer);
        this.viewer.addSelectionChangedListener(event -> {
            this.contextMenu.getMenu().setVisible(true);
            this.contextMenu.getMenu().setVisible(false);
        });
        this.makeActions();
        this.hookContextMenu();
        this.hookDoubleClickAction();
        this.contributeToActionBars();
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.updateOnline();
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    private void hookContextMenu() {
        this.contextMenu = new MenuManager("#PopupMenu");
        this.contextMenu.setRemoveAllWhenShown(true);
        this.contextMenu.addMenuListener(this::fillContextMenu);
        Menu menu = this.contextMenu.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(this.contextMenu, (ISelectionProvider)this.viewer);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    protected void fillLocalPullDown(IMenuManager manager) {
        manager.add((IContributionItem)new Separator("additions"));
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IContributionItem)new Separator("additions"));
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void hookDoubleClickAction() {
        this.viewer.addDoubleClickListener(this::doDoubleClick);
    }

    protected void doDoubleClick(DoubleClickEvent event) {
    }

    protected void makeActions() {
    }

    protected void configureViewer(TreeViewer treeViewer) {
    }

    public StructuredViewer getViewer() {
        return this.viewer;
    }

    private void updateOnline() {
        this.getSite().getWorkbenchWindow().getShell().getDisplay().asyncExec(() -> {
            if (this.online) {
                this.geheOnline();
            } else {
                this.geheOffline();
            }
        });
    }

    public boolean isOnline() {
        return this.online;
    }

    protected void geheOnline() {
        this.viewer.getControl().setEnabled(true);
        this.viewer.refresh();
        this.setContentDescription("");
    }

    protected void geheOffline() {
        if (!this.viewer.getControl().isDisposed()) {
            this.viewer.getControl().setEnabled(false);
            this.setContentDescription("Keine Verbindung zum Datenverteiler.");
        }
    }

    public void dispose() {
        this.davProvider.removePropertyChangeListener("verbunden", (PropertyChangeListener)this.verbundenPropertyChangeListener);
        super.dispose();
    }

    private final class VerbundenPropertyChangeListener
    implements PropertyChangeListener {
        private VerbundenPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            AbstractEinstellungenView.this.online = (Boolean)evt.getNewValue();
            AbstractEinstellungenView.this.updateOnline();
        }
    }
}

