/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.rw.bitctrl.eclipse.modell;

import com.bitctrl.model.ModelElement;
import de.bsvrz.buv.rw.basislib.einstellungen.EinstellungChangeListener;
import de.bsvrz.buv.rw.basislib.einstellungen.Einstellungen;
import de.bsvrz.buv.rw.basislib.einstellungen.EinstellungsAdresse;
import de.bsvrz.buv.rw.basislib.einstellungen.EinstellungsEvent;
import de.bsvrz.buv.rw.basislib.einstellungen.SpeicherKey;
import de.bsvrz.buv.rw.bitctrl.internal.BitCtrlRahmenwerkPlugin;
import de.bsvrz.buv.rw.bitctrl.internal.RahmenwerkService;
import de.bsvrz.puk.param.lib.daten.UrlasserInfo;
import de.bsvrz.sys.funclib.debug.Debug;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public abstract class ModellEinstellungen<N, T>
extends ModelElement {
    private static final long serialVersionUID = 1L;
    public static final String PROP_EINSTELLUNG_CHANGED = "einstellungChanged";
    private final Class<T> type;
    private final Debug logger = Debug.getLogger();

    protected ModellEinstellungen(Class<T> type) {
        this.type = type;
        Einstellungen verwaltung = RahmenwerkService.getService().getEinstellungen();
        verwaltung.addEinstellungsListener(new EinstellungChangeListener(){

            public void einstellungEntfernt(EinstellungsEvent event) {
                ModellEinstellungen.this.firePropertyChanged(ModellEinstellungen.PROP_EINSTELLUNG_CHANGED, null, null);
            }

            public void einstellungAngelegt(EinstellungsEvent event) {
                ModellEinstellungen.this.firePropertyChanged(ModellEinstellungen.PROP_EINSTELLUNG_CHANGED, null, null);
            }

            public void einstellungAktualisiert(EinstellungsEvent event) {
                ModellEinstellungen.this.firePropertyChanged(ModellEinstellungen.PROP_EINSTELLUNG_CHANGED, null, null);
            }
        });
    }

    protected abstract T getObject(N var1);

    protected abstract void setObject(N var1, T var2);

    protected abstract String getName(N var1);

    protected abstract void setName(N var1, String var2);

    protected abstract Date getLastModification(N var1);

    protected abstract void setLastModification(N var1, Date var2);

    protected abstract N createStorage();

    final Map<String, WizardPageItem<T>> getModellEinstellungen(SpeicherKey art) {
        List<N> contents = this.getModellEinstellungenList(art);
        HashMap<String, WizardPageItem<T>> ret = new HashMap<String, WizardPageItem<T>>();
        if (contents != null) {
            for (N named : contents) {
                T object = this.getObject(named);
                if (!this.type.isInstance(object)) continue;
                WizardPageItem<T> r = new WizardPageItem<T>();
                r.setName(this.getName(named));
                r.setLastModification(this.getLastModification(named));
                r.setObject(object);
                ret.put(r.getName(), r);
            }
        }
        return ret;
    }

    protected List<? extends N> getModellEinstellungenList(SpeicherKey art) {
        Einstellungen einstellungen = RahmenwerkService.getService().getEinstellungen();
        EinstellungsAdresse adresse = new EinstellungsAdresse(null, this.type.getName(), art.getOwnerType(), art.getPid(), art.getLocation());
        try {
            String parameter = (String)einstellungen.getValue(adresse);
            List<N> contents = this.getModellEinstellungenInternal(parameter);
            return contents;
        }
        catch (IOException ex) {
            this.logger.warning(ex.getLocalizedMessage());
            return Collections.emptyList();
        }
    }

    public T getModellEinstellungen(SpeicherKey art, String name) {
        List<N> contents = this.getModellEinstellungenList(art);
        for (N named : contents) {
            if (!this.getName(named).equals(name)) continue;
            return this.getObject(named);
        }
        return null;
    }

    public List<String> getModellEinstellungenNamen(SpeicherKey art) {
        ArrayList<String> result = new ArrayList<String>();
        List<N> contents = this.getModellEinstellungenList(art);
        for (N named : contents) {
            result.add(this.getName(named));
        }
        return result;
    }

    public List<T> getAlleModellEinstellungen(SpeicherKey art) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (String name : this.getModellEinstellungenNamen(art)) {
            result.add(this.getModellEinstellungen(art, name));
        }
        result.removeIf(Objects::isNull);
        return result;
    }

    protected abstract List<N> getModellEinstellungenInternal(String var1);

    public void setModellEinstellungen(SpeicherKey art, String name, T object) throws IOException {
        EinstellungsAdresse adresse;
        Einstellungen verwaltung = RahmenwerkService.getService().getEinstellungen();
        String param = (String)verwaltung.getValue(adresse = new EinstellungsAdresse(null, this.type.getName(), art.getOwnerType(), art.getPid(), art.getLocation()));
        List<N> contents = this.getModellEinstellungenInternal(param);
        if (contents != null) {
            boolean hasSet = false;
            for (N named : contents) {
                String contentsName = this.getName(named);
                if (contentsName == null || !contentsName.equals(name)) continue;
                this.setObject(named, object);
                this.setLastModification(named, new Date());
                hasSet = true;
                break;
            }
            if (!hasSet) {
                N named;
                named = this.createStorage();
                this.setName(named, name);
                this.setObject(named, object);
                this.setLastModification(named, new Date());
                contents.add(named);
            }
        }
        param = this.saveModellEinstellungenInternal(contents);
        verwaltung.setValue(adresse, (Object)param);
        this.firePropertyChanged(PROP_EINSTELLUNG_CHANGED, null, name);
    }

    protected abstract String saveModellEinstellungenInternal(List<N> var1);

    protected final Class<T> getTypeClass() {
        return this.type;
    }

    protected void handleReadError(Exception ex, String message) {
        String error = message != null ? message : "Die Benutzereinstellungen konnten wegen eines Fehlers beim Deserialisieren nicht gelesen werden.";
        BitCtrlRahmenwerkPlugin.getDefault().getLogger().error(error + ": " + ex.getLocalizedMessage());
    }

    protected void handleWriteError(Exception ex, String message) {
        String error = message != null ? message : "Die Benutzereinstellungen konnten wegen eines Fehlers beim Serialisieren nicht geschrieben werden.";
        BitCtrlRahmenwerkPlugin.getDefault().getLogger().error(error, (Throwable)ex);
    }

    public void setModellEinstellungen(SpeicherKey art, String name, T object, UrlasserInfo urlasser) throws IOException {
        EinstellungsAdresse adresse;
        Einstellungen verwaltung = RahmenwerkService.getService().getEinstellungen();
        String param = (String)verwaltung.getValue(adresse = new EinstellungsAdresse(null, this.type.getName(), art.getOwnerType(), art.getPid(), art.getLocation()));
        List<N> contents = this.getModellEinstellungenInternal(param);
        if (contents != null) {
            boolean hasSet = false;
            for (N named : contents) {
                String contentsName = this.getName(named);
                if (contentsName == null || !contentsName.equals(name)) continue;
                this.setObject(named, object);
                this.setLastModification(named, new Date());
                hasSet = true;
                break;
            }
            if (!hasSet) {
                N named;
                named = this.createStorage();
                this.setName(named, name);
                this.setObject(named, object);
                this.setLastModification(named, new Date());
                contents.add(named);
            }
        }
        param = this.saveModellEinstellungenInternal(contents);
        verwaltung.setValue(adresse, (Object)param, urlasser);
        this.firePropertyChanged(PROP_EINSTELLUNG_CHANGED, null, name);
    }

    static class WizardPageItem<T> {
        private String name;
        private Date lastModification;
        private T object;

        WizardPageItem() {
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setLastModification(Date lastModification) {
            this.lastModification = lastModification;
        }

        public Date getLastModification() {
            return this.lastModification;
        }

        public void setObject(T object) {
            this.object = object;
        }

        public T getObject() {
            return this.object;
        }
    }
}

