/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.rw.bitctrl.eclipse.modell;

import com.bitctrl.lib.eclipse.actions.SaveAction;
import com.bitctrl.lib.eclipse.databinding.observables.ObservableMapKeySet;
import com.bitctrl.lib.eclipse.databinding.wizards.EnterOrSelectStringWizardPage;
import com.bitctrl.lib.eclipse.wizards.ComposedWizardDialog;
import de.bsvrz.buv.rw.basislib.Rahmenwerk;
import de.bsvrz.buv.rw.basislib.einstellungen.SpeicherKey;
import de.bsvrz.buv.rw.basislib.urlasser.UrlasserInfoDatenDialog;
import de.bsvrz.buv.rw.basislib.urlasser.UrlasserInfoDatenSender;
import de.bsvrz.buv.rw.bitctrl.eclipse.Messages;
import de.bsvrz.buv.rw.bitctrl.eclipse.modell.ModellEinstellungen;
import de.bsvrz.buv.rw.bitctrl.eclipse.wizards.SelectEinstellungsArtWizardPage;
import de.bsvrz.buv.rw.bitctrl.internal.BitCtrlRahmenwerkPlugin;
import de.bsvrz.buv.rw.bitctrl.internal.RahmenwerkService;
import de.bsvrz.dav.daf.main.ClientDavInterface;
import de.bsvrz.puk.param.lib.daten.UrlasserInfo;
import de.bsvrz.sys.funclib.bitctrl.modell.ObjektFactory;
import de.bsvrz.sys.funclib.bitctrl.modell.util.benutzer.Benutzerverwaltung;
import java.io.IOException;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.map.WritableMap;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public abstract class ModellSaveAction<N, T>
extends SaveAction {
    protected ModellSaveAction() {
        this.setToolTipText("Einstellungen speichern");
    }

    public final void run() {
        try {
            Rahmenwerk rahmenwerk = RahmenwerkService.getService().getRahmenWerk();
            if (!rahmenwerk.isOnline()) {
                return;
            }
            ObjektFactory factory = RahmenwerkService.getService().getObjektFactory();
            Benutzerverwaltung benutzerverwaltung = new Benutzerverwaltung(factory);
            boolean isAdmin = benutzerverwaltung.isDAVAdmin(rahmenwerk.getBenutzerName(), rahmenwerk.getPasswort());
            WritableValue nameValue = new WritableValue((Object)this.getCurrentName(), String.class);
            WritableMap cps = new WritableMap();
            WritableValue artValue = new WritableValue(null, SpeicherKey.class);
            ModellEinstellungen<N, T> einstellungen = this.createModelEinstellungen();
            artValue.addValueChangeListener(arg_0 -> ModellSaveAction.lambda$0((IObservableMap)cps, (IObservableValue)artValue, einstellungen, arg_0));
            artValue.setValue((Object)SpeicherKey.benutzerNetzweit());
            EnterOrSelectStringWizardPage page2 = new EnterOrSelectStringWizardPage(Messages.EMFModelSaveAction_WizardHeader, Messages.EMFModelSaveAction_WizardDescription, Messages.EMFModelSaveAction_WizardPrompt1, Messages.EMFModelSaveAction_OR, Messages.EMFModelSaveAction_WizardPrompt2, (IObservableValue)nameValue, (IObservableSet)new ObservableMapKeySet((IObservableMap)cps));
            SelectEinstellungsArtWizardPage page1 = new SelectEinstellungsArtWizardPage((IObservableValue)artValue);
            page1.setErlaubeNetzweit(isAdmin);
            Display display = PlatformUI.createDisplay();
            Shell shell = display.getActiveShell();
            ComposedWizardDialog wizard = new ComposedWizardDialog(shell, Messages.EMFModelSaveAction_WizardCaption, new IWizardPage[]{page1, page2});
            if (wizard.open() == 0) {
                String newName = (String)nameValue.getValue();
                UrlasserInfoDatenDialog dialog = new UrlasserInfoDatenDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (UrlasserInfoDatenSender)new ModellSaveUrlasserInfoDatenSender(einstellungen, (IObservableValue<SpeicherKey>)artValue, newName));
                dialog.open();
            }
        }
        catch (Exception e) {
            BitCtrlRahmenwerkPlugin.getDefault().getLog().log((IStatus)new Status(4, "de.bsvrz.buv.rw.bitctrl", "Beim Speichern der Einstellungen ist ein Fehler aufgetreten", (Throwable)e));
        }
    }

    protected abstract String getCurrentName();

    protected abstract T getObject(String var1);

    protected void saveHook(String newName) {
    }

    protected abstract ModellEinstellungen<N, T> createModelEinstellungen();

    private static /* synthetic */ void lambda$0(IObservableMap iObservableMap, IObservableValue iObservableValue, ModellEinstellungen modellEinstellungen, ValueChangeEvent event) {
        iObservableMap.clear();
        SpeicherKey art = (SpeicherKey)iObservableValue.getValue();
        if (art != null) {
            iObservableMap.putAll(modellEinstellungen.getModellEinstellungen(art));
        }
    }

    private final class ModellSaveUrlasserInfoDatenSender
    implements UrlasserInfoDatenSender {
        private final ModellEinstellungen<N, T> einstellungen;
        private final IObservableValue<SpeicherKey> artValue;
        private final String newName;

        private ModellSaveUrlasserInfoDatenSender(ModellEinstellungen<N, T> einstellungen, IObservableValue<SpeicherKey> artValue, String newName) {
            this.einstellungen = einstellungen;
            this.artValue = artValue;
            this.newName = newName;
        }

        public void execute(ClientDavInterface verbindung, UrlasserInfo urlasser) {
            try {
                this.einstellungen.setModellEinstellungen((SpeicherKey)this.artValue.getValue(), this.newName, ModellSaveAction.this.getObject(this.newName));
                ModellSaveAction.this.saveHook(this.newName);
            }
            catch (IOException ex) {
                ErrorDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Benutzereinstellungen", (String)"Die Einstellungen konnten nicht gesichert werden!", (IStatus)new Status(4, "de.bsvrz.buv.rw.bitctrl", ex.getLocalizedMessage(), (Throwable)ex));
            }
        }
    }
}

