/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.rw.bitctrl.eclipse.modell.emf;

import com.bitctrl.lib.eclipse.emf.eclipse.model.Named;
import de.bsvrz.buv.rw.basislib.einstellungen.EinstellungOwnerType;
import de.bsvrz.buv.rw.basislib.einstellungen.SpeicherKey;
import de.bsvrz.buv.rw.bitctrl.eclipse.modell.emf.EMFModellEinstellungen;
import de.bsvrz.buv.rw.bitctrl.eclipse.modell.emf.EinstellungenHelper;
import de.bsvrz.buv.rw.bitctrl.eclipse.util.RahmenwerkUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.ui.IWorkbenchPart;

class BaseEinstellungAction<T extends Named>
extends Action {
    private final IWorkbenchPart workbenchPart;
    private final EMFModellEinstellungen<T> einstellungen;

    BaseEinstellungAction(IWorkbenchPart workbenchPart, EMFModellEinstellungen<T> einstellungen) {
        Assert.isNotNull((Object)workbenchPart, (String)"workbenchPart darf nicht null sein");
        Assert.isNotNull(einstellungen, (String)"einstellungen darf nicht null sein");
        this.workbenchPart = workbenchPart;
        this.einstellungen = einstellungen;
    }

    IWorkbenchPart getWorkbenchPart() {
        return this.workbenchPart;
    }

    EMFModellEinstellungen<T> getEinstellungen() {
        return this.einstellungen;
    }

    List<TreePath> getReadableEinstellungen() {
        return this.getSelectedEinstellungen(false);
    }

    List<TreePath> getWritableEinstellungen() {
        return this.getSelectedEinstellungen(true);
    }

    private List<TreePath> getSelectedEinstellungen(boolean onlyWritable) {
        ISelection selection = this.workbenchPart.getSite().getSelectionProvider().getSelection();
        if (selection.isEmpty() || !(selection instanceof ITreeSelection)) {
            return Collections.emptyList();
        }
        ArrayList<TreePath> result = new ArrayList<TreePath>();
        TreePath[] treePathArray = ((ITreeSelection)selection).getPaths();
        int n = treePathArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreePath path = treePathArray[n2];
            Named einstellung = EinstellungenHelper.getEinstellung(path);
            SpeicherKey einstellungsArt = EinstellungenHelper.getEinstellungsArt(path);
            if ((!onlyWritable || RahmenwerkUtils.isAdmin() || einstellungsArt.getOwnerType() != EinstellungOwnerType.SYSTEM) && einstellung != null && einstellungsArt != null) {
                result.add(path);
            }
            ++n2;
        }
        return result;
    }
}

