/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.rw.bitctrl.eclipse.modell.emf;

import com.bitctrl.lib.eclipse.emf.eclipse.model.Named;
import de.bsvrz.buv.rw.basislib.einstellungen.EinstellungOwnerType;
import de.bsvrz.buv.rw.basislib.einstellungen.SpeicherKey;
import de.bsvrz.buv.rw.bitctrl.eclipse.modell.emf.BaseEinstellungAction;
import de.bsvrz.buv.rw.bitctrl.eclipse.modell.emf.EMFModellEinstellungen;
import de.bsvrz.buv.rw.bitctrl.eclipse.modell.emf.EinstellungenHelper;
import de.bsvrz.buv.rw.bitctrl.eclipse.util.RahmenwerkUtils;
import de.bsvrz.buv.rw.bitctrl.internal.BitCtrlRahmenwerkPlugin;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class CopyEinstellungAction<T extends Named>
extends BaseEinstellungAction<T> {
    public CopyEinstellungAction(IWorkbenchPart part, EMFModellEinstellungen<T> einstellungen) {
        super(part, einstellungen);
        this.setId("org.eclipse.ui.edit.copy");
        this.setActionDefinitionId("org.eclipse.ui.edit.copy");
    }

    public void run() {
        final List<TreePath> readable = this.getReadableEinstellungen();
        Assert.isTrue((!readable.isEmpty() ? 1 : 0) != 0, (String)"Kopieren (Duplizieren) kann nicht ausgef\u00fchrt werden, wenn nichts markiert ist.");
        EClass classname = this.getEinstellungen().getEClass();
        final String dialogTitle = classname.getName() + " kopieren";
        String dialogMessage = "Bitte geben an wohin die Objekte kopiert werden sollen?";
        ArrayList<SpeicherKey> einstellungsArten = new ArrayList<SpeicherKey>();
        for (SpeicherKey key : SpeicherKey.getDefaultKeys()) {
            if (key.getOwnerType() == EinstellungOwnerType.SYSTEM && !RahmenwerkUtils.isAdmin()) continue;
            einstellungsArten.add(key);
        }
        Shell shell = this.getWorkbenchPart().getSite().getShell();
        final ElementListSelectionDialog dlg = new ElementListSelectionDialog(shell, (ILabelProvider)new LabelProvider());
        dlg.setTitle(dialogTitle);
        dlg.setMessage("Bitte geben an wohin die Objekte kopiert werden sollen?");
        dlg.setMultipleSelection(false);
        dlg.setElements(einstellungsArten.toArray());
        if (dlg.open() == 0) {
            Job job = new Job(dialogTitle){

                protected IStatus run(IProgressMonitor monitor) {
                    monitor.beginTask(dialogTitle, readable.size());
                    SpeicherKey zielArt = (SpeicherKey)dlg.getFirstResult();
                    for (TreePath path : readable) {
                        Named einstellungQuelle = EinstellungenHelper.getEinstellung(path);
                        Named einstellungZiel = (Named)EcoreUtil.copy((EObject)einstellungQuelle);
                        if (EcoreUtil.getID((EObject)einstellungZiel) != null) {
                            EcoreUtil.setID((EObject)einstellungZiel, (String)EcoreUtil.generateUUID());
                        }
                        String name = einstellungZiel.getName();
                        int index = 0;
                        while (CopyEinstellungAction.this.getEinstellungen().getModellEinstellungen(zielArt, einstellungZiel.getName()) != null) {
                            if (index == 0) {
                                neuerName = "Kopie von " + name;
                                einstellungZiel.setName(neuerName);
                            } else {
                                neuerName = "Kopie (" + index + ") von " + name;
                                einstellungZiel.setName(neuerName);
                            }
                            ++index;
                        }
                        try {
                            CopyEinstellungAction.this.getEinstellungen().setModellEinstellungen(zielArt, einstellungZiel.getName(), einstellungZiel);
                        }
                        catch (IOException ex) {
                            BitCtrlRahmenwerkPlugin.getDefault().getLog().log((IStatus)new Status(2, "de.bsvrz.buv.rw.bitctrl", "Speichern des Objektes " + einstellungZiel.getName() + " fehlgeschlagen.", (Throwable)ex));
                        }
                        monitor.worked(1);
                    }
                    monitor.done();
                    return Status.OK_STATUS;
                }
            };
            job.setUser(true);
            job.schedule();
        }
    }
}

