/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.rw.bitctrl.eclipse.modell.emf;

import com.bitctrl.lib.eclipse.emf.eclipse.model.Named;
import com.bitctrl.util.CollectionUtilities;
import de.bsvrz.buv.rw.bitctrl.eclipse.modell.emf.BaseEinstellungAction;
import de.bsvrz.buv.rw.bitctrl.eclipse.modell.emf.EMFModellEinstellungen;
import de.bsvrz.buv.rw.bitctrl.eclipse.modell.emf.EinstellungenHelper;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;

public class DeleteEinstellungAction<T extends Named>
extends BaseEinstellungAction<T> {
    public DeleteEinstellungAction(IWorkbenchPart part, EMFModellEinstellungen<T> einstellungen) {
        super(part, einstellungen);
        this.setId("org.eclipse.ui.edit.delete");
        this.setActionDefinitionId("org.eclipse.ui.edit.delete");
    }

    public void run() {
        String dialogMessage;
        List<TreePath> readable = this.getReadableEinstellungen();
        final List<TreePath> writable = this.getWritableEinstellungen();
        Assert.isTrue((!readable.isEmpty() ? 1 : 0) != 0, (String)"L\u00f6schen kann nicht ausgef\u00fchrt werden, wenn nichts markiert ist.");
        Shell shell = this.getWorkbenchPart().getSite().getShell();
        if (readable.size() != writable.size()) {
            List unwritable = CollectionUtilities.difference(readable, writable);
            MessageDialog.openInformation((Shell)shell, (String)"Hinweis", (String)("Sie k\u00f6nnen die folgenden Objekte nicht l\u00f6schen, weil Sie nicht \u00fcber die notwendigen Rechte verf\u00fcgen:\n\n" + EinstellungenHelper.getObjectList(unwritable)));
        }
        if (writable.isEmpty()) {
            return;
        }
        String classname = this.getEinstellungen().getEClass().getName();
        final String dialogTitle = classname + " l\u00f6schen";
        DeleteMessageDialog dailog = new DeleteMessageDialog(shell, dialogTitle, null, dialogMessage = "Sollen die folgenden Objekte wirklich gel\u00f6scht werden? Die Aktion kann nicht r\u00fcckg\u00e4ngig gemacht werden.\n\n" + EinstellungenHelper.getObjectList(writable), 3, 0, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL});
        if (dailog.open() == 0) {
            Job job = new Job(dialogTitle){

                protected IStatus run(IProgressMonitor monitor) {
                    monitor.beginTask(dialogTitle, writable.size());
                    IWorkbenchPartSite site = DeleteEinstellungAction.this.getWorkbenchPart().getSite();
                    site.getShell().getDisplay().syncExec(() -> {
                        for (TreePath path : writable) {
                            EinstellungenHelper.delete(DeleteEinstellungAction.this.getEinstellungen(), path);
                            monitor.worked(1);
                        }
                    });
                    monitor.done();
                    return Status.OK_STATUS;
                }
            };
            job.setUser(true);
            job.schedule();
        }
    }

    private final class DeleteMessageDialog
    extends MessageDialog {
        private DeleteMessageDialog(Shell parentShell, String dialogTitle, Image dialogTitleImage, String dialogMessage, int dialogImageType, int defaultIndex, String[] dialogButtonLabels) {
            super(parentShell, dialogTitle, dialogTitleImage, dialogMessage, dialogImageType, defaultIndex, dialogButtonLabels);
        }

        protected int getShellStyle() {
            return super.getShellStyle() | 0x10000000;
        }

        protected Control createMessageArea(Composite composite) {
            Image image = this.getImage();
            if (image != null) {
                this.imageLabel = new Label(composite, 0);
                image.setBackground(this.imageLabel.getBackground());
                this.imageLabel.setImage(image);
                GridDataFactory.fillDefaults().align(0x1000000, 1).applyTo((Control)this.imageLabel);
            }
            if (this.message != null) {
                ScrolledComposite scroll = new ScrolledComposite(composite, 768);
                scroll.setLayout((Layout)new GridLayout());
                scroll.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
                this.messageLabel = new Label((Composite)scroll, this.getMessageLabelStyle());
                this.messageLabel.setText(this.message);
                GridDataFactory.fillDefaults().align(4, 1).grab(true, false).hint(this.convertHorizontalDLUsToPixels(300), -1).applyTo((Control)this.messageLabel);
                scroll.setContent((Control)this.messageLabel);
                scroll.setExpandHorizontal(true);
                scroll.setExpandVertical(true);
                scroll.setMinSize(this.messageLabel.computeSize(-1, -1));
            }
            return composite;
        }
    }
}

