/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.rw.bitctrl.eclipse.modell.emf;

import com.bitctrl.lib.eclipse.emf.eclipse.model.Named;
import de.bsvrz.buv.rw.basislib.einstellungen.SpeicherKey;
import de.bsvrz.buv.rw.bitctrl.eclipse.modell.emf.EMFModellEinstellungen;
import java.io.IOException;
import java.util.List;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

final class EinstellungenHelper {
    private EinstellungenHelper() {
    }

    static void delete(EMFModellEinstellungen<?> einstellungen, TreePath path) {
        IEditorPart editorPart = EinstellungenHelper.getEditorPart(path);
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        while (editorPart != null) {
            page.closeEditor(editorPart, false);
            editorPart = EinstellungenHelper.getEditorPart(path);
        }
        SpeicherKey einstellungsArt = EinstellungenHelper.getEinstellungsArt(path);
        String name = EinstellungenHelper.getEinstellung(path).getName();
        try {
            einstellungen.setModellEinstellungen(einstellungsArt, name, null, null);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    static Named getEinstellung(TreePath path) {
        if (path.getLastSegment() instanceof Named) {
            return (Named)path.getLastSegment();
        }
        return null;
    }

    static SpeicherKey getEinstellungsArt(TreePath path) {
        if (path.getFirstSegment() instanceof SpeicherKey) {
            return (SpeicherKey)path.getFirstSegment();
        }
        return null;
    }

    private static IEditorPart getEditorPart(TreePath path) {
        Named einstellung = EinstellungenHelper.getEinstellung(path);
        SpeicherKey art = EinstellungenHelper.getEinstellungsArt(path);
        if (einstellung == null || art == null) {
            return null;
        }
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IEditorReference[] iEditorReferenceArray = page.getEditorReferences();
        int n = iEditorReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference e = iEditorReferenceArray[n2];
            IEditorPart editorPart = e.getEditor(false);
            if (editorPart != null) {
                IEditorInput input = editorPart.getEditorInput();
                Named editorEinsgtellung = (Named)input.getAdapter(einstellung.getClass());
                SpeicherKey editorArt = (SpeicherKey)input.getAdapter(SpeicherKey.class);
                if (editorEinsgtellung != null && editorArt != null && einstellung.getName().equals(editorEinsgtellung.getName()) && art.equals((Object)editorArt)) {
                    return editorPart;
                }
            }
            ++n2;
        }
        return null;
    }

    static String getObjectList(List<TreePath> paths) {
        StringBuilder result = new StringBuilder();
        for (TreePath path : paths) {
            if (result.length() > 0) {
                result.append('\n');
            }
            result.append(EinstellungenHelper.getEinstellungsArt(path));
            result.append(": ");
            Named named = EinstellungenHelper.getEinstellung(path);
            if (named != null) {
                result.append(named.getName());
                continue;
            }
            result.append("unbekannt");
        }
        return result.toString();
    }
}

