/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.rw.bitctrl.eclipse.modell.emf;

import com.bitctrl.lib.eclipse.emf.eclipse.model.Named;
import com.bitctrl.util.CollectionUtilities;
import de.bsvrz.buv.rw.basislib.einstellungen.EinstellungOwnerType;
import de.bsvrz.buv.rw.basislib.einstellungen.SpeicherKey;
import de.bsvrz.buv.rw.basislib.einstellungen.UrlasserDialogAbgebrochenException;
import de.bsvrz.buv.rw.bitctrl.eclipse.modell.emf.BaseEinstellungAction;
import de.bsvrz.buv.rw.bitctrl.eclipse.modell.emf.EMFModellEinstellungen;
import de.bsvrz.buv.rw.bitctrl.eclipse.modell.emf.EinstellungenHelper;
import de.bsvrz.buv.rw.bitctrl.eclipse.util.RahmenwerkUtils;
import de.bsvrz.buv.rw.bitctrl.internal.BitCtrlRahmenwerkPlugin;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class MoveEinstellungAction<T extends Named>
extends BaseEinstellungAction<T> {
    public MoveEinstellungAction(IWorkbenchPart part, EMFModellEinstellungen<T> einstellungen) {
        super(part, einstellungen);
        this.setId("org.eclipse.ui.edit.move");
        this.setActionDefinitionId("org.eclipse.ui.edit.move");
    }

    public void run() {
        List<TreePath> readable = this.getReadableEinstellungen();
        final List<TreePath> writable = this.getWritableEinstellungen();
        Assert.isTrue((!readable.isEmpty() ? 1 : 0) != 0, (String)"Verschieben kann nicht ausgef\u00fchrt werden, wenn nichts markiert ist.");
        final Shell shell = this.getWorkbenchPart().getSite().getShell();
        if (readable.size() != writable.size()) {
            List unwritable = CollectionUtilities.difference(readable, writable);
            MessageDialog.openInformation((Shell)shell, (String)"Hinweis", (String)("Sie k\u00f6nnen die folgenden Objekte nicht verschieben, weil Sie nicht \u00fcber die notwendigen Rechte verf\u00fcgen:\n\n" + EinstellungenHelper.getObjectList(unwritable)));
        }
        if (writable.isEmpty()) {
            return;
        }
        String classname = this.getEinstellungen().getEClass().getName();
        final String dialogTitle = classname + " verschieben";
        String dialogMessage = "Bitte geben an wohin die Objekte verschoben werden sollen?";
        ArrayList<SpeicherKey> einstellungsArten = new ArrayList<SpeicherKey>();
        for (SpeicherKey key : SpeicherKey.getDefaultKeys()) {
            if (key.getOwnerType() == EinstellungOwnerType.SYSTEM && !RahmenwerkUtils.isAdmin()) continue;
            einstellungsArten.add(key);
        }
        final ElementListSelectionDialog dlg = new ElementListSelectionDialog(shell, (ILabelProvider)new LabelProvider());
        dlg.setTitle(dialogTitle);
        dlg.setMessage("Bitte geben an wohin die Objekte verschoben werden sollen?");
        dlg.setMultipleSelection(false);
        dlg.setElements(einstellungsArten.toArray());
        if (dlg.open() == 0) {
            Job job = new Job(dialogTitle){

                protected IStatus run(IProgressMonitor monitor) {
                    monitor.beginTask(dialogTitle, writable.size());
                    SpeicherKey zielArt = (SpeicherKey)dlg.getFirstResult();
                    for (TreePath path : writable) {
                        Named einstellungQuelle = EinstellungenHelper.getEinstellung(path);
                        String name = einstellungQuelle.getName();
                        if (MoveEinstellungAction.this.getEinstellungen().getModellEinstellungen(zielArt, einstellungQuelle.getName()) != null) {
                            InputDialog renameDialog = new InputDialog(shell, dialogTitle, "Am Ziel existiert bereits eine Einstellung mit dem selben Namen. Bitte geben Sie einen neuen Namen f\u00fcr " + name + " an", name, (IInputValidator)new EinstellungInputValidator(name, zielArt));
                            shell.getDisplay().syncExec(() -> {
                                if (renameDialog.open() == 0) {
                                    MoveEinstellungAction.this.doMove(monitor, path, zielArt, renameDialog.getValue());
                                }
                            });
                        } else {
                            MoveEinstellungAction.this.doMove(monitor, path, zielArt, name);
                        }
                        try {
                            MoveEinstellungAction.this.getEinstellungen().setModellEinstellungen(zielArt, einstellungQuelle.getName(), einstellungQuelle);
                        }
                        catch (IOException ex) {
                            BitCtrlRahmenwerkPlugin.getDefault().getLog().warn("Fehler beim Speichern von Modell-Einstellungen.", (Throwable)ex);
                        }
                        monitor.worked(1);
                    }
                    monitor.done();
                    return Status.OK_STATUS;
                }
            };
            job.setUser(true);
            job.schedule();
        }
    }

    private void doMove(IProgressMonitor monitor, TreePath path, SpeicherKey zielArt, String neuerName) {
        Named einstellungQuelle = EinstellungenHelper.getEinstellung(path);
        String classname = this.getEinstellungen().getEClass().getName();
        Named einstellungZiel = (Named)EcoreUtil.copy((EObject)einstellungQuelle);
        einstellungZiel.setName(neuerName);
        if (EcoreUtil.getID((EObject)einstellungZiel) != null) {
            EcoreUtil.setID((EObject)einstellungZiel, (String)EcoreUtil.generateUUID());
        }
        monitor.subTask("Sichere Objekt " + classname + " unter seinem neuen Namen " + einstellungZiel.getName() + " ...");
        try {
            this.getEinstellungen().setModellEinstellungen(zielArt, einstellungZiel.getName(), einstellungZiel);
            monitor.subTask("Warte auf Datenverteiler ...");
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            monitor.subTask("L\u00f6sche altes Objekt " + classname + " mit dem Namen " + einstellungQuelle.getName() + " ...");
            this.getWorkbenchPart().getSite().getShell().getDisplay().syncExec(() -> EinstellungenHelper.delete(this.getEinstellungen(), path));
        }
        catch (UrlasserDialogAbgebrochenException urlasserDialogAbgebrochenException) {
        }
        catch (IOException ex) {
            ErrorDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"FEHLER", (String)"Objekt konnte nicht verschoben werden!", (IStatus)new Status(4, "de.bsvrz.buv.rw.bitctrl", ex.getLocalizedMessage(), (Throwable)ex));
        }
    }

    private final class EinstellungInputValidator
    implements IInputValidator {
        private final String name;
        private final SpeicherKey zielArt;

        private EinstellungInputValidator(String name, SpeicherKey zielArt) {
            this.name = name;
            this.zielArt = zielArt;
        }

        public String isValid(String newText) {
            if (newText.isEmpty()) {
                return "Der Name muss mindestens ein Zeichen lang sein.";
            }
            if (MoveEinstellungAction.this.getEinstellungen().getModellEinstellungen(this.zielArt, newText) != null) {
                return "Es existiert bereits ein Objekt mit dem angegebenen Namen.";
            }
            if (newText.equals(this.name)) {
                return "Der neue Name ist identisch mit dem alten.";
            }
            return null;
        }
    }
}

