/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.rw.bitctrl.eclipse.modell.emf;

import com.bitctrl.lib.eclipse.emf.eclipse.model.Named;
import com.bitctrl.util.CollectionUtilities;
import de.bsvrz.buv.rw.basislib.einstellungen.SpeicherKey;
import de.bsvrz.buv.rw.basislib.einstellungen.UrlasserDialogAbgebrochenException;
import de.bsvrz.buv.rw.bitctrl.eclipse.modell.emf.BaseEinstellungAction;
import de.bsvrz.buv.rw.bitctrl.eclipse.modell.emf.EMFModellEinstellungen;
import de.bsvrz.buv.rw.bitctrl.eclipse.modell.emf.EinstellungenHelper;
import java.io.IOException;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class RenameEinstellungAction<T extends Named>
extends BaseEinstellungAction<T> {
    public RenameEinstellungAction(IWorkbenchPart part, EMFModellEinstellungen<T> einstellungen) {
        super(part, einstellungen);
        this.setId("org.eclipse.ui.edit.rename");
        this.setActionDefinitionId("org.eclipse.ui.edit.rename");
    }

    public void run() {
        List<TreePath> readable = this.getReadableEinstellungen();
        List<TreePath> writable = this.getWritableEinstellungen();
        Assert.isTrue((!readable.isEmpty() ? 1 : 0) != 0, (String)"Umbenennen kann nicht ausgef\u00fchrt werden, wenn nichts markiert ist.");
        Shell shell = this.getWorkbenchPart().getSite().getShell();
        if (readable.size() != writable.size()) {
            List unwritable = CollectionUtilities.difference(readable, writable);
            MessageDialog.openInformation((Shell)shell, (String)"Hinweis", (String)("Sie k\u00f6nnen die folgenden Objekte nicht umbenennen, weil Sie nicht \u00fcber die notwendigen Rechte verf\u00fcgen:\n\n" + EinstellungenHelper.getObjectList(unwritable)));
        }
        if (writable.isEmpty()) {
            return;
        }
        final String classname = this.getEinstellungen().getEClass().getName();
        final String dialogTitle = classname + " umbenennen";
        for (final TreePath path : writable) {
            String dialogMessage;
            InputDialog dlg;
            Named einstellungQuelle = EinstellungenHelper.getEinstellung(path);
            final String nameQuelle = einstellungQuelle.getName();
            final SpeicherKey art = EinstellungenHelper.getEinstellungsArt(path);
            final Named einstellungZiel = (Named)EcoreUtil.copy((EObject)einstellungQuelle);
            if (EcoreUtil.getID((EObject)einstellungZiel) != null) {
                EcoreUtil.setID((EObject)einstellungZiel, (String)EcoreUtil.generateUUID());
            }
            if ((dlg = new InputDialog(shell, dialogTitle, dialogMessage = "Bitte geben Sie den neuen Namen f\u00fcr " + nameQuelle + " an.", nameQuelle, (IInputValidator)new RenameInputValidator(art, nameQuelle))).open() != 0) continue;
            einstellungZiel.setName(dlg.getValue());
            Job job = new Job(dialogTitle){

                protected IStatus run(IProgressMonitor monitor) {
                    monitor.beginTask(dialogTitle + " von " + nameQuelle + " nach " + einstellungZiel.getName(), 3);
                    monitor.subTask("Sichere Objekt " + classname + " unter seinem neuen Namen " + einstellungZiel.getName() + " ...");
                    try {
                        RenameEinstellungAction.this.getEinstellungen().setModellEinstellungen(art, einstellungZiel.getName(), einstellungZiel);
                        monitor.worked(1);
                        monitor.subTask("Warte auf Datenverteiler ...");
                        try {
                            Thread.sleep(3000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        monitor.worked(1);
                        monitor.subTask("L\u00f6sche altes Objekt " + classname + " mit dem Namen " + nameQuelle + " ...");
                        RenameEinstellungAction.this.getWorkbenchPart().getSite().getShell().getDisplay().syncExec(() -> EinstellungenHelper.delete(RenameEinstellungAction.this.getEinstellungen(), path));
                        monitor.worked(1);
                    }
                    catch (UrlasserDialogAbgebrochenException urlasserDialogAbgebrochenException) {
                    }
                    catch (IOException ex) {
                        ErrorDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"FEHLER", (String)"Objekt konnte nicht umbenannt werden!", (IStatus)new Status(4, "de.bsvrz.buv.rw.bitctrl", ex.getLocalizedMessage(), (Throwable)ex));
                    }
                    monitor.done();
                    return Status.OK_STATUS;
                }
            };
            job.setUser(true);
            job.schedule();
        }
    }

    private final class RenameInputValidator
    implements IInputValidator {
        private final SpeicherKey art;
        private final String nameQuelle;

        private RenameInputValidator(SpeicherKey art, String nameQuelle) {
            this.art = art;
            this.nameQuelle = nameQuelle;
        }

        public String isValid(String newText) {
            if (newText.isEmpty()) {
                return "Der Name muss mindestens ein Zeichen lang sein.";
            }
            if (RenameEinstellungAction.this.getEinstellungen().getModellEinstellungen(this.art, newText) != null) {
                return "Es existiert bereits ein Objekt mit dem angegebenen Namen.";
            }
            if (newText.equals(this.nameQuelle)) {
                return "Der neue Name ist identisch mit dem alten.";
            }
            return null;
        }
    }
}

