/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.rw.bitctrl.eclipse.modell.java;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import de.bsvrz.buv.rw.bitctrl.eclipse.modell.ModellEinstellungen;
import de.bsvrz.buv.rw.bitctrl.eclipse.modell.java.storage.Named;
import de.bsvrz.buv.rw.bitctrl.eclipse.modell.java.storage.NamedObjectList;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class JavaModellEinstellungen<T>
extends ModellEinstellungen<Named, T> {
    private static final long serialVersionUID = 1L;
    private final List<Class<?>> contextClasses = new ArrayList();

    public JavaModellEinstellungen(Class<T> type) {
        super(type);
        this.addContextClass(NamedObjectList.class);
        this.addContextClass(type);
    }

    public void addContextClass(Class<?> clazz) {
        this.contextClasses.add(clazz);
    }

    @Override
    protected T getObject(Named named) {
        return (T)named.getObject();
    }

    @Override
    protected void setObject(Named named, T object) {
        named.setObject(object);
    }

    @Override
    protected String getName(Named named) {
        return named.getName();
    }

    @Override
    protected void setName(Named named, String name) {
        named.setName(name);
    }

    @Override
    protected void setLastModification(Named named, Date lastModification) {
        named.setLastModification(lastModification);
    }

    @Override
    protected Date getLastModification(Named named) {
        return named.getLastModification();
    }

    @Override
    protected Named createStorage() {
        return new Named();
    }

    @Override
    protected List<Named> getModellEinstellungenInternal(String param) {
        if (param != null) {
            try {
                Gson gson = new GsonBuilder().registerTypeAdapter(Named.class, (Object)this.createAdapter()).create();
                NamedObjectList namedObjectList = (NamedObjectList)gson.fromJson(param, NamedObjectList.class);
                return namedObjectList.getContents();
            }
            catch (Exception ex) {
                this.handleReadError(ex, null);
            }
        }
        return new ArrayList<Named>();
    }

    @Override
    protected String saveModellEinstellungenInternal(List<Named> contents) {
        Iterator<Named> iterator = contents.iterator();
        while (iterator.hasNext()) {
            if (iterator.next().getObject() != null) continue;
            iterator.remove();
        }
        try {
            NamedObjectList namedObjectList = new NamedObjectList();
            namedObjectList.setContents(contents);
            Gson gson = new GsonBuilder().registerTypeAdapter(Named.class, (Object)this.createAdapter()).create();
            return gson.toJson((Object)namedObjectList);
        }
        catch (Exception ex) {
            this.handleWriteError(ex, null);
            return "";
        }
    }

    private NamedObjectAdapter createAdapter() {
        NamedObjectAdapter adapter = new NamedObjectAdapter();
        adapter.registerType(Named.class.getName(), Named.class);
        for (Class<?> c : this.contextClasses) {
            adapter.registerType(c.getName(), c);
        }
        return adapter;
    }

    private static class NamedObjectAdapter
    implements JsonSerializer<Named>,
    JsonDeserializer<Named> {
        private final Map<String, Class<?>> typeRegistry = new HashMap();

        private NamedObjectAdapter() {
        }

        public void registerType(String typeName, Class<?> type) {
            this.typeRegistry.put(typeName, type);
        }

        public JsonElement serialize(Named wrapper, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jsonObject = new JsonObject();
            String typeName = wrapper.getObject().getClass().getName();
            jsonObject.addProperty("type", typeName);
            jsonObject.add("properties", context.serialize(wrapper.getObject()));
            jsonObject.addProperty("name", wrapper.getName());
            jsonObject.addProperty("lastModification", (Number)wrapper.getLastModification().getTime());
            return jsonObject;
        }

        public Named deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jsonObject = json.getAsJsonObject();
            String typeName = jsonObject.get("type").getAsString();
            JsonElement properties = jsonObject.get("properties");
            Class<?> clazz = this.typeRegistry.get(typeName);
            if (clazz == null) {
                throw new JsonParseException("Unbekannter Typ: " + typeName);
            }
            Named result = new Named();
            result.setObject(context.deserialize(properties, clazz));
            result.setName(jsonObject.get("name").getAsString());
            result.setLastModification(new Date(jsonObject.get("lastModification").getAsLong()));
            return result;
        }
    }
}

