/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.rw.bitctrl.eclipse.views;

import com.bitctrl.lib.eclipse.BitCtrlEclipseCommonPlugin;
import com.bitctrl.lib.eclipse.help.DefaultHelpContext;
import com.bitctrl.lib.eclipse.viewer.ViewerTools;
import de.bsvrz.buv.rw.bitctrl.eclipse.Messages;
import de.bsvrz.buv.rw.bitctrl.eclipse.MultipleSelection;
import de.bsvrz.buv.rw.bitctrl.eclipse.PatternOrSubstringFilter;
import de.bsvrz.buv.rw.bitctrl.eclipse.SystemObjectTreeContentProvider;
import de.bsvrz.buv.rw.bitctrl.eclipse.SystemObjectTypeLabelProvider;
import de.bsvrz.buv.rw.bitctrl.internal.RahmenwerkService;
import de.bsvrz.dav.daf.main.ClientDavInterface;
import de.bsvrz.dav.daf.main.config.DataModel;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.dav.daf.main.config.SystemObjectType;
import de.bsvrz.sys.funclib.bitctrl.modell.ObjektFactory;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.part.ViewPart;

public abstract class SystemObjectAuswahlView
extends ViewPart
implements ISelectionListener {
    private final MultipleSelection multi;
    private final String[] rootTypes;
    protected FilteredTree filteredTree;
    private final List<SystemObject> currentSelection = new ArrayList<SystemObject>();
    private Form form;
    private ViewRefresher viewRefresher;
    private Action linkAction;
    private IStructuredSelection lastSelection;

    protected SystemObjectAuswahlView(MultipleSelection multipleSelection, String ... rootTypes) {
        this.multi = multipleSelection;
        this.rootTypes = rootTypes;
        this.setPartName(((Object)((Object)this)).getClass().getName());
    }

    public void createPartControl(Composite parent) {
        FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        this.form = toolkit.createForm(parent);
        toolkit.decorateFormHeading(this.form);
        Label headLabel = toolkit.createLabel(this.form.getHead(), Messages.SystemObjectAuswahl_Description, 64);
        headLabel.setBackground(null);
        this.form.setHeadClient((Control)headLabel);
        Composite formBody = this.form.getBody();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)formBody, this.getHelpId());
        formBody.setLayout((Layout)new GridLayout());
        this.filteredTree = new FilteredTree(formBody, 0x800 | this.multi.getSwtConstant(), (PatternFilter)new PatternOrSubstringFilter(), true, true);
        toolkit.adapt((Composite)this.filteredTree);
        this.filteredTree.getViewer().setContentProvider((IContentProvider)new SystemObjectTreeContentProvider());
        this.filteredTree.setInitialText(Messages.SystemObjectAuswahl_DefaultFilter);
        this.filteredTree.getViewer().setComparator(new ViewerComparator());
        TreeSelectionChangedListener selectionListener = new TreeSelectionChangedListener();
        this.filteredTree.getViewer().addSelectionChangedListener((ISelectionChangedListener)selectionListener);
        this.filteredTree.addDisposeListener(e -> this.filteredTree.getViewer().removeSelectionChangedListener(selectionListener));
        this.filteredTree.getViewer().addDoubleClickListener(event -> this.handleDoubleClick(event, this.currentSelection));
        this.filteredTree.getViewer().setLabelProvider((IBaseLabelProvider)new SystemObjectTypeLabelProvider());
        this.getSite().setSelectionProvider((ISelectionProvider)this.filteredTree.getViewer());
        this.viewRefresher = new ViewRefresher();
        RahmenwerkService.getService().getObjektFactory().addPropertyChangeListener((PropertyChangeListener)this.viewRefresher);
        this.viewRefresher.run();
        this.linkAction = new Action("Selektion verkn\u00fcpfen", 2){

            public void run() {
                SystemObjectAuswahlView.this.selectionChanged(null, (ISelection)SystemObjectAuswahlView.this.lastSelection);
            }
        };
        this.linkAction.setImageDescriptor(BitCtrlEclipseCommonPlugin.getDefault().getImageDescriptor("/icons/full/elcl16/synced.gif"));
        this.getViewSite().getActionBars().getToolBarManager().add((IAction)this.linkAction);
        this.getSite().getWorkbenchWindow().getSelectionService().addSelectionListener((ISelectionListener)this);
    }

    protected String getHelpId() {
        return DefaultHelpContext.getDefaultContextId(((Object)((Object)this)).getClass());
    }

    protected void handleDoubleClick(DoubleClickEvent event, List<SystemObject> currentSelection) {
    }

    public void setFocus() {
        this.filteredTree.setFocus();
    }

    protected MenuManager setupPopupMenu(Composite parent) {
        MenuManager menuManager = new MenuManager("#PopupMenu");
        this.filteredTree.getViewer().getControl().setMenu(menuManager.createContextMenu((Control)parent));
        this.getViewSite().registerContextMenu(menuManager, (ISelectionProvider)this.filteredTree.getViewer());
        return menuManager;
    }

    public void dispose() {
        RahmenwerkService.getService().getObjektFactory().removePropertyChangeListener((PropertyChangeListener)this.viewRefresher);
        super.dispose();
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (((Object)((Object)this)).equals(part)) {
            return;
        }
        HashSet systemObjects = new HashSet(ViewerTools.getTypedSelection((ISelection)selection, SystemObject.class));
        if (systemObjects.isEmpty()) {
            return;
        }
        if (!this.filteredTree.getViewer().getTree().isDisposed()) {
            TreeItem[] treeSel = this.filteredTree.getViewer().getTree().getSelection();
            HashSet<SystemObject> treeData = new HashSet<SystemObject>();
            TreeItem[] treeItemArray = treeSel;
            int n = treeSel.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem treeItem = treeItemArray[n2];
                treeData.add((SystemObject)treeItem.getData());
                ++n2;
            }
            this.lastSelection = (IStructuredSelection)selection;
            if (systemObjects.equals(treeData)) {
                return;
            }
            if (this.linkAction.isChecked()) {
                this.filteredTree.getViewer().setSelection((ISelection)new StructuredSelection(new ArrayList(systemObjects)), true);
            }
        }
    }

    private final class TreeSelectionChangedListener
    implements ISelectionChangedListener {
        private TreeSelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            SystemObjectAuswahlView.this.currentSelection.clear();
            SystemObjectAuswahlView.this.currentSelection.addAll(event.getStructuredSelection().toList());
            Iterator<SystemObject> it = SystemObjectAuswahlView.this.currentSelection.iterator();
            while (it.hasNext()) {
                SystemObject object = it.next();
                if (!(object instanceof SystemObjectType)) continue;
                it.remove();
            }
        }
    }

    private final class ViewRefresher
    implements PropertyChangeListener,
    Runnable {
        private ViewRefresher() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (SystemObjectAuswahlView.this.filteredTree != null) {
                SystemObjectAuswahlView.this.form.getDisplay().asyncExec((Runnable)this);
            }
        }

        @Override
        public void run() {
            if (SystemObjectAuswahlView.this.form != null && !SystemObjectAuswahlView.this.form.isDisposed()) {
                SystemObjectAuswahlView.this.form.setMessage(null);
                try {
                    ArrayList<SystemObject> systemObjects = new ArrayList<SystemObject>();
                    ObjektFactory objektFactory = RahmenwerkService.getService().getObjektFactory();
                    if (objektFactory.isVerbunden()) {
                        ClientDavInterface daVVerbindung = objektFactory.getDav();
                        DataModel dataModel = daVVerbindung.getDataModel();
                        String[] stringArray = SystemObjectAuswahlView.this.rootTypes;
                        int n = SystemObjectAuswahlView.this.rootTypes.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String rootType = stringArray[n2];
                            systemObjects.add(dataModel.getObject(rootType));
                            ++n2;
                        }
                    } else {
                        SystemObjectAuswahlView.this.form.setMessage(Messages.SystemObjectAuswahl_ERROR_DAV_NOT_INITIALIZED, 3);
                    }
                    TreeViewer viewer = SystemObjectAuswahlView.this.filteredTree.getViewer();
                    viewer.setInput((Object)systemObjects.toArray());
                    viewer.refresh();
                }
                catch (RuntimeException re) {
                    String message = SystemObjectAuswahlView.this.form.getMessage();
                    SystemObjectAuswahlView.this.form.setMessage((String)(message == null ? "" : message + "\n" + re.getLocalizedMessage()));
                }
            }
        }
    }
}

