/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.rw.bitctrl.eclipse.widgets;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Widget;

public class AutoIncrementSpinner
extends Composite
implements DisposeListener {
    static final int SPINNER_SINGLE_INCREMENT = 978;
    static final int SPINNER_PAGE_INCREMENT = 987;
    private final WritableValue minimum = new WritableValue((Object)-2147483647, Integer.TYPE);
    private final WritableValue maximum = new WritableValue((Object)Integer.MAX_VALUE, Integer.TYPE);
    private final IObservableValue observableModel = new WritableValue((Object)0, Integer.TYPE);
    private final Spinner spinner;
    private final IValueChangeListener target2Model;
    private final IValueChangeListener model2Target;
    private final IObservableValue observableTarget;

    public AutoIncrementSpinner(Composite parent, int style) {
        super(parent, 0);
        this.setLayout((Layout)new FillLayout());
        this.spinner = new Spinner((Composite)this, style);
        this.target2Model = new Target2Model();
        this.model2Target = new Model2Target();
        this.observableTarget = WidgetProperties.spinnerSelection().observe((Widget)this.spinner);
        this.observableTarget.addValueChangeListener(this.target2Model);
        this.observableModel.addValueChangeListener(this.model2Target);
        DataBindingContext dbc = new DataBindingContext();
        dbc.bindValue((IObservableValue)WidgetProperties.minimum().observe((Widget)this.spinner), (IObservableValue)this.minimum);
        dbc.bindValue((IObservableValue)WidgetProperties.maximum().observe((Widget)this.spinner), (IObservableValue)this.maximum);
        this.spinner.setValues(0, Integer.MIN_VALUE, Integer.MAX_VALUE, 0, 987, 978);
        this.addDisposeListener(this);
    }

    public void widgetDisposed(DisposeEvent e) {
        this.observableTarget.removeValueChangeListener(this.target2Model);
        this.observableModel.removeValueChangeListener(this.model2Target);
    }

    public IObservableValue getObservableValue() {
        return this.observableModel;
    }

    public int getSelection() {
        return (Integer)this.observableModel.getValue();
    }

    public void setSelection(int value) {
        this.observableModel.setValue((Object)value);
    }

    public int getMinimum() {
        return (Integer)this.minimum.getValue();
    }

    public void setMinimum(int value) {
        if (this.getMaximum() < value) {
            this.setMaximum(value);
        }
        if (this.getSelection() < value) {
            this.setSelection(value);
        }
        this.minimum.setValue((Object)value);
    }

    public IObservableValue observeMinimum() {
        return this.minimum;
    }

    public int getMaximum() {
        return (Integer)this.maximum.getValue();
    }

    public void setMaximum(int value) {
        if (this.getMinimum() > value) {
            this.setMinimum(value);
        }
        if (this.getSelection() > value) {
            this.setSelection(value);
        }
        this.maximum.setValue((Object)value);
    }

    public IObservableValue observeMaximum() {
        return this.maximum;
    }

    private final class Model2Target
    implements IValueChangeListener {
        private Model2Target() {
        }

        public void handleValueChange(ValueChangeEvent event) {
            Integer integer = (Integer)event.diff.getNewValue();
            if (integer != null) {
                if (AutoIncrementSpinner.this.spinner.getSelection() == integer.intValue()) {
                    integer = null;
                }
            } else {
                integer = 0;
            }
            if (integer != null) {
                AutoIncrementSpinner.this.spinner.setValues(integer.intValue(), Integer.MIN_VALUE, Integer.MAX_VALUE, 0, 987, 978);
            }
        }
    }

    private final class Target2Model
    implements IValueChangeListener {
        private Target2Model() {
        }

        public void handleValueChange(ValueChangeEvent event) {
            Integer newValue = (Integer)event.diff.getNewValue();
            Integer oldValue = (Integer)AutoIncrementSpinner.this.observableModel.getValue();
            if (oldValue != null && newValue != null) {
                newValue = (int)this.dynamicRound(oldValue.intValue(), newValue.intValue());
                Integer max = (Integer)AutoIncrementSpinner.this.maximum.getValue();
                Integer min = (Integer)AutoIncrementSpinner.this.minimum.getValue();
                if (max != null) {
                    newValue = Math.min(newValue, max);
                }
                if (min != null) {
                    newValue = Math.max(newValue, min);
                }
                if (oldValue.equals(newValue)) {
                    AutoIncrementSpinner.this.observableTarget.setValue((Object)newValue);
                }
            }
            AutoIncrementSpinner.this.observableModel.setValue((Object)newValue);
        }

        private long dynamicRound(long oldValue, long newValue) {
            int grow;
            int oldSign = (int)Math.signum(oldValue);
            if (oldSign == 0) {
                oldSign = 1;
            }
            if ((grow = oldSign * (int)Math.signum(newValue - oldValue)) == 0) {
                return newValue;
            }
            long distance = (long)Math.abs((double)newValue - (double)oldValue);
            if (987L != distance && 978L != distance) {
                return newValue;
            }
            distance = 987L == distance ? 1L : 10L;
            if (0L == oldValue) {
                return (long)grow * distance;
            }
            long oldVal = Math.abs(oldValue);
            long ticks = 100L;
            double[] values = new double[]{1.0, 2.0, 5.0, 10.0};
            double[] multiplier = new double[values.length - 1];
            int mCount = multiplier.length;
            int i = 0;
            while (i < mCount) {
                multiplier[i] = values[i + 1] / values[i];
                ++i;
            }
            int mIndex = 0;
            double stepping = Math.max(1.0, Math.pow(10.0, Math.floor(Math.log10(oldVal)) - 2.0));
            long newVal = this.calcNewVal(oldVal, grow, distance, stepping);
            while (this.growFactor(grow, oldVal, newVal) >= (double)(100L / distance)) {
                newVal = this.calcNewVal(oldVal, grow, distance, stepping *= multiplier[mIndex]);
                if (stepping > 1.0E7) break;
                mIndex = (mIndex + 1) % mCount;
            }
            return newVal * (long)oldSign;
        }

        private double growFactor(int grow, long oldVal, long newVal) {
            return 1 == grow ? (double)oldVal / ((double)newVal - (double)oldVal) : (double)newVal / ((double)oldVal - (double)newVal);
        }

        private long calcNewVal(long oldVal, int grow, long distance, double stepping) {
            double dx = ((double)oldVal + (double)((long)grow * distance) * stepping) / ((double)distance * stepping);
            double x = 1 == grow ? Math.floor(dx) : Math.ceil(dx);
            return Math.min(Integer.MAX_VALUE, (long)(x * (double)distance * stepping));
        }
    }
}

