/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.rw.bitctrl.eclipse.widgets;

import com.bitctrl.lib.eclipse.BitCtrlEclipseCommonPlugin;
import com.bitctrl.lib.eclipse.databinding.observables.SilencePolicy;
import com.bitctrl.lib.eclipse.databinding.observables.SilentComputedValue;
import com.bitctrl.lib.eclipse.databinding.realm.RealmRunnable;
import com.bitctrl.lib.eclipse.resources.WidgetImageRegistry;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.Observables;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class ColorPicker
extends Composite
implements ISelectionProvider {
    private static final RGB BLACK = new RGB(0, 0, 0);
    private static final RGB WHITE = new RGB(255, 255, 255);
    private final WritableValue<RGB> color = new WritableValue(null, RGB.class);
    private final Label colorText;
    private final Label colorAction;
    private final IObservableValue<Boolean> enabledState = new WritableValue((Object)true, Boolean.TYPE);
    private final List<ISelectionChangedListener> selectionListeners = new ArrayList<ISelectionChangedListener>();
    private ResourceManager resourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)this);

    public ColorPicker(Composite parent, int style) {
        this(parent, style, (RGB)null);
    }

    public ColorPicker(Composite parent, int style, RGB defaultRGB) {
        this(parent, style, (IObservableValue<RGB>)Observables.constantObservableValue((Object)defaultRGB));
    }

    public ColorPicker(Composite parent, int style, final IObservableValue<RGB> defaultRGB) {
        super(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        this.colorText = new Label((Composite)this, style | 0x1000000);
        GridData layoutData = new GridData(4, 0x1000000, true, false);
        layoutData.heightHint = 17;
        this.colorText.setLayoutData((Object)layoutData);
        this.colorText.setText("undef.");
        this.colorAction = new Label((Composite)this, style);
        this.colorAction.setImage(WidgetImageRegistry.getInstance((Widget)this).getImage(BitCtrlEclipseCommonPlugin.getDefault().getImageDescriptor("/icons/full/etool16/edit.gif")));
        this.colorAction.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        DataBindingContext dbc = new DataBindingContext();
        SilentComputedValue bgColor = new SilentComputedValue(defaultRGB.getRealm(), RGB.class, SilencePolicy.EqualsSign){

            protected RGB calculate() {
                RGB rgb = (RGB)ColorPicker.this.color.getValue();
                if (rgb == null) {
                    if (defaultRGB != null) {
                        rgb = (RGB)defaultRGB.getValue();
                    }
                    if (rgb == null) {
                        rgb = BLACK;
                    }
                }
                if (Boolean.FALSE.equals(ColorPicker.this.enabledState.getValue())) {
                    rgb = new RGB((rgb.red + 192) / 2, (rgb.green + 192) / 2, (rgb.blue + 192) / 2);
                }
                return rgb;
            }
        };
        dbc.bindValue((IObservableValue)WidgetProperties.background().observe((Widget)this.colorText), (IObservableValue)new SilentComputedValue(defaultRGB.getRealm(), Color.class, SilencePolicy.EqualsSign, (IObservableValue)bgColor){
            private final /* synthetic */ IObservableValue val$bgColor;
            {
                this.val$bgColor = iObservableValue;
                super($anonymous0, $anonymous1, $anonymous2);
            }

            protected Color calculate() {
                return ColorPicker.this.resourceManager.createColor((RGB)this.val$bgColor.getValue());
            }
        });
        dbc.bindValue((IObservableValue)WidgetProperties.foreground().observe((Widget)this.colorText), (IObservableValue)new SilentComputedValue(defaultRGB.getRealm(), Color.class, SilencePolicy.EqualsSign, (IObservableValue)bgColor){
            private final /* synthetic */ IObservableValue val$bgColor;
            {
                this.val$bgColor = iObservableValue;
                super($anonymous0, $anonymous1, $anonymous2);
            }

            protected Color calculate() {
                RGB rgb = (RGB)ColorPicker.this.color.getValue();
                if (rgb == null) {
                    rgb = (RGB)this.val$bgColor.getValue();
                    int grey = (rgb.red * 30 + rgb.green * 59 + rgb.blue * 11) / 100;
                    rgb = grey < 128 ? WHITE : BLACK;
                }
                return ColorPicker.this.resourceManager.createColor(rgb);
            }
        });
        MouseAdapter mouseListener = new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                Point position = ColorPicker.this.getDisplay().map((Control)ColorPicker.this, null, 0, 0);
                Shell shell = new Shell(ColorPicker.this.getShell());
                position.y = Math.max(0, position.y - 319);
                position.x = Math.max(0, position.x - 20);
                shell.setLocation(position);
                ColorDialog cd = new ColorDialog(shell);
                cd.setText("Linienfarbe w\u00e4hlen...");
                cd.setRGB((RGB)ColorPicker.this.color.getValue());
                RGB newColor = cd.open();
                if (newColor == null) {
                    return;
                }
                ColorPicker.this.color.setValue((Object)newColor);
                ColorPicker.this.notifySelectionListeners();
            }
        };
        this.colorText.addMouseListener((MouseListener)mouseListener);
        this.colorAction.addMouseListener((MouseListener)mouseListener);
    }

    private void notifySelectionListeners() {
        for (ISelectionChangedListener listener : this.selectionListeners) {
            listener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, this.getSelection()));
        }
    }

    public IObservableValue<RGB> getColor() {
        return this.color;
    }

    public RGB getColorValue() {
        return (RGB)this.color.getValue();
    }

    public void setColor(RGB color) {
        RealmRunnable.syncExec((Realm)this.color.getRealm(), () -> this.color.setValue((Object)color));
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.colorText.setEnabled(enabled);
        this.colorAction.setEnabled(enabled);
        this.enabledState.setValue((Object)enabled);
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.add(listener);
    }

    public ISelection getSelection() {
        return new StructuredSelection((Object)this.getColorValue());
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.remove(listener);
    }

    public void setSelection(ISelection selection) {
        this.setColor((RGB)((StructuredSelection)selection).getFirstElement());
    }
}

