/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.rw.bitctrl.eclipse.wizards;

import de.bsvrz.buv.rw.basislib.kalender.DatumZeit;
import de.bsvrz.buv.rw.bitctrl.eclipse.wizards.ZeitAuswahlDialog;
import de.bsvrz.dav.daf.main.Data;
import de.bsvrz.dav.daf.main.config.TimeAttributeType;
import java.util.Date;
import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class DatumZeitDialog
extends ZeitAuswahlDialog {
    private DatumZeit datumZeit;

    public DatumZeitDialog(Shell parentShell, long initialValue) {
        super(parentShell, initialValue);
    }

    public DatumZeitDialog(Shell parentShell, Data initialData) {
        super(parentShell, initialData);
        TimeAttributeType attrType = (TimeAttributeType)initialData.getAttributeType();
        Assert.isTrue((!attrType.isRelative() ? 1 : 0) != 0);
    }

    protected Control createDialogArea(Composite parent) {
        parent.getShell().setText("Auswahl des Zeitpunktes");
        parent.getShell().setImage(parent.getDisplay().getSystemImage(4));
        this.setTitle("Auswahl eines absoluten Zeitpunktes");
        StringBuilder neueMessage = new StringBuilder("Auswahl eines absoluten Zeitpunktes, ").append(this.genauigkeitMillis ? "milli" : "").append("sekundengenau");
        if (this.attributName != null) {
            neueMessage.append(",\nf\u00fcr Attribut '").append(this.attributName).append("'");
        }
        this.setMessage(neueMessage.toString(), 1);
        Composite panel = new Composite(parent, 0);
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        gl.marginLeft = 40;
        gl.marginRight = 0;
        gl.verticalSpacing = 10;
        panel.setLayout((Layout)gl);
        GridData gd = new GridData(768);
        gd.widthHint = 60;
        panel.setLayoutData((Object)gd);
        Label labelDatum = new Label(panel, 0);
        labelDatum.setText("Zeitpunkt:");
        gd = new GridData(16384, 128, false, false);
        gd.horizontalSpan = 1;
        gd.horizontalAlignment = 16384;
        labelDatum.setLayoutData((Object)gd);
        DatumZeit.Eingabetyp eingabeTyp = this.genauigkeitMillis ? DatumZeit.Eingabetyp.datumuhrMS : DatumZeit.Eingabetyp.datumuhr;
        this.datumZeit = new DatumZeit(panel, 0, eingabeTyp, true, true);
        this.datumZeit.setToolTipText("Datum und Uhrzeit");
        this.datumZeit.setLayout((Layout)new GridLayout());
        this.datumZeit.setDatum(new Date(this.initialValue));
        gd = new GridData(16384, 128, true, false);
        gd.horizontalSpan = 1;
        gd.horizontalAlignment = 131072;
        this.datumZeit.setLayoutData((Object)gd);
        return panel;
    }

    protected void okPressed() {
        this.selectedValue = this.datumZeit.getDatum().getTime();
        super.okPressed();
    }
}

