/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.rw.bitctrl.eclipse.wizards;

import de.bsvrz.buv.rw.basislib.einstellungen.EinstellungLocation;
import de.bsvrz.buv.rw.basislib.einstellungen.SpeicherKey;
import de.bsvrz.buv.rw.bitctrl.eclipse.util.RahmenwerkUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class EinstellungsArtWizardPage
extends WizardPage {
    private Collection<SpeicherKey> preSelection;
    private Map<SpeicherKey, Button> einstellungsArten;
    private boolean multiple;

    public EinstellungsArtWizardPage(String pageName) {
        super(pageName);
        this.setTitle("Einstellungsart");
        this.setDescription("Bitte w\u00e4hlen Sie die gew\u00fcnschten Einstellungsarten.");
        this.setPageComplete(false);
    }

    public void setMultiple(boolean multiple) {
        this.multiple = multiple;
    }

    public boolean isMultiple() {
        return this.multiple;
    }

    public Collection<SpeicherKey> getPreSelection() {
        if (this.preSelection == null) {
            return Collections.emptyList();
        }
        return this.preSelection;
    }

    public void setPreSelection(Collection<SpeicherKey> preSelection) {
        this.preSelection = preSelection;
    }

    public void createControl(Composite parent) {
        this.einstellungsArten = new HashMap<SpeicherKey, Button>();
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(1, false));
        SelectionAdapter selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EinstellungsArtWizardPage.this.updatePageComplete();
            }
        };
        for (SpeicherKey einstellungsArt : SpeicherKey.getDefaultKeys()) {
            if (!RahmenwerkUtils.isAdmin() && einstellungsArt.getLocation() == EinstellungLocation.NETZWERKWEIT) continue;
            int flags = this.isMultiple() ? 32 : 16;
            Button button = new Button(container, flags);
            button.setText(einstellungsArt.getTypBezeichnung());
            if (this.getPreSelection().contains(einstellungsArt)) {
                button.setSelection(true);
            }
            button.addSelectionListener((SelectionListener)selectionListener);
            this.einstellungsArten.put(einstellungsArt, button);
        }
        this.updatePageComplete();
        this.setControl((Control)container);
    }

    public Set<SpeicherKey> getEinstellungsArten() {
        HashSet<SpeicherKey> result = new HashSet<SpeicherKey>();
        for (Map.Entry<SpeicherKey, Button> entry : this.einstellungsArten.entrySet()) {
            if (!entry.getValue().getSelection()) continue;
            result.add(entry.getKey());
        }
        return result;
    }

    public SpeicherKey getFirstEinstellungsArt() {
        ArrayList<SpeicherKey> result = new ArrayList<SpeicherKey>();
        for (Map.Entry<SpeicherKey, Button> entry : this.einstellungsArten.entrySet()) {
            if (!entry.getValue().getSelection()) continue;
            result.add(entry.getKey());
        }
        return (SpeicherKey)result.get(0);
    }

    private void updatePageComplete() {
        boolean complete = false;
        for (Button b : this.einstellungsArten.values()) {
            complete |= b.getSelection();
        }
        this.setPageComplete(complete);
    }
}

