/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.rw.bitctrl.eclipse.wizards;

import de.bsvrz.buv.rw.basislib.Rahmenwerk;
import de.bsvrz.buv.rw.basislib.einstellungen.EinstellungLocation;
import de.bsvrz.buv.rw.basislib.einstellungen.EinstellungOwnerType;
import de.bsvrz.buv.rw.basislib.einstellungen.SpeicherKey;
import de.bsvrz.buv.rw.bitctrl.eclipse.Messages;
import de.bsvrz.buv.rw.bitctrl.internal.RahmenwerkService;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class SelectEinstellungsArtWizardPage
extends WizardPage {
    private boolean erlaubeNetzweit = true;
    private SpeicherKey einstellungsArt;
    private Group artGroup;
    private final IObservableValue observer;

    public SelectEinstellungsArtWizardPage(SpeicherKey defaultArt) {
        super(SelectEinstellungsArtWizardPage.class.getName());
        this.einstellungsArt = defaultArt;
        this.observer = null;
    }

    public SelectEinstellungsArtWizardPage(IObservableValue observableValue) {
        super(SelectEinstellungsArtWizardPage.class.getName());
        Assert.isTrue((boolean)SpeicherKey.class.equals(observableValue.getValueType()));
        this.observer = observableValue;
        this.einstellungsArt = (SpeicherKey)observableValue.getValue();
    }

    public void createControl(Composite parent) {
        this.setTitle(Messages.SelectEinstellungsArtWizardPage_Title);
        this.setDescription(Messages.SelectEinstellungsArtWizardPage_Description);
        Composite control = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        control.setLayout((Layout)layout);
        new Label(control, 0).setText(Messages.SelectEinstellungsArtWizardPage_Prompt);
        this.artGroup = new Group(control, 64);
        this.artGroup.setText("Einstellungsart");
        this.artGroup.setLayout((Layout)new GridLayout(1, false));
        LinkedHashMap<SpeicherKey, String> arten = new LinkedHashMap<SpeicherKey, String>();
        Rahmenwerk rahmenwerk = RahmenwerkService.getService().getRahmenWerk();
        if (rahmenwerk.isOnline() && this.erlaubeNetzweit) {
            arten.put(new SpeicherKey(EinstellungOwnerType.BENUTZER, EinstellungLocation.LOKAL, rahmenwerk.getBenutzer().getPid()), Messages.EinstellungsArt_benutzerLokal);
            arten.put(new SpeicherKey(EinstellungOwnerType.BENUTZER, EinstellungLocation.NETZWERKWEIT, rahmenwerk.getBenutzer().getPid()), Messages.EinstellungsArt_benutzerNetzweit);
            arten.put(new SpeicherKey(EinstellungOwnerType.SYSTEM, EinstellungLocation.LOKAL), Messages.EinstellungsArt_allgemeinLokal);
            arten.put(new SpeicherKey(EinstellungOwnerType.SYSTEM, EinstellungLocation.NETZWERKWEIT), Messages.EinstellungsArt_allgemeinNetzweit);
        } else {
            arten.put(new SpeicherKey(EinstellungOwnerType.SYSTEM, EinstellungLocation.LOKAL), Messages.EinstellungsArt_allgemeinLokal);
        }
        for (Map.Entry entry : arten.entrySet()) {
            Button button = new Button((Composite)this.artGroup, 16);
            button.setText((String)entry.getValue());
            button.setData(entry.getKey());
            button.setSelection(((SpeicherKey)entry.getKey()).equals((Object)this.einstellungsArt));
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SelectEinstellungsArtWizardPage.this.validatePage();
                }
            });
        }
        this.validatePage();
        this.setControl((Control)control);
    }

    protected void validatePage() {
        if (this.artGroup != null) {
            Control[] controlArray = this.artGroup.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object data;
                Control child = controlArray[n2];
                if (child instanceof Button && ((Button)child).getSelection() && (data = child.getData()) instanceof SpeicherKey) {
                    this.einstellungsArt = (SpeicherKey)data;
                    if (this.observer == null) break;
                    this.observer.setValue((Object)this.einstellungsArt);
                    break;
                }
                ++n2;
            }
        }
        this.setPageComplete(this.einstellungsArt != null);
    }

    public SpeicherKey getArt() {
        return this.einstellungsArt;
    }

    public final boolean isErlaubeNetzweit() {
        return this.erlaubeNetzweit;
    }

    public final void setErlaubeNetzweit(boolean erlaubeNetzweit) {
        this.erlaubeNetzweit = erlaubeNetzweit;
    }
}

