/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.rw.bitctrl.eclipse.wizards;

import com.bitctrl.lib.eclipse.wizards.ComposedWizardDialog;
import de.bsvrz.buv.rw.bitctrl.eclipse.Messages;
import de.bsvrz.buv.rw.bitctrl.eclipse.MultipleSelection;
import de.bsvrz.buv.rw.bitctrl.eclipse.PatternOrSubstringFilter;
import de.bsvrz.buv.rw.bitctrl.eclipse.SystemObjectAuswahlType;
import de.bsvrz.buv.rw.bitctrl.eclipse.SystemObjectTreeContentProvider;
import de.bsvrz.buv.rw.bitctrl.eclipse.SystemObjectTypeLabelProvider;
import de.bsvrz.buv.rw.bitctrl.internal.RahmenwerkService;
import de.bsvrz.dav.daf.main.ClientDavInterface;
import de.bsvrz.dav.daf.main.config.DataModel;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.dav.daf.main.config.SystemObjectType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;

public class SystemObjectAuswahlWizardPage
extends WizardPage
implements ComposedWizardDialog.CloseWizardHandler {
    private FilteredTree filteredTree;
    private final String[] rootTypes;
    private final List<SystemObject> result = new ArrayList<SystemObject>();
    private final MultipleSelection multi;
    private final SystemObjectAuswahlType selectionType;

    public SystemObjectAuswahlWizardPage(String title, MultipleSelection multi, SystemObjectAuswahlType selectionType, List<SystemObject> preSelectedObjects, String ... rootTypes) {
        super(SystemObjectAuswahlWizardPage.class.getName());
        Assert.isNotNull((Object)((Object)selectionType));
        this.multi = multi;
        this.rootTypes = rootTypes;
        this.selectionType = selectionType;
        if (preSelectedObjects != null) {
            this.result.addAll(preSelectedObjects);
        }
        this.setTitle(title);
        this.setDescription(Messages.SystemObjectAuswahl_Description);
    }

    public void createControl(Composite parent) {
        ArrayList<SystemObject> systemObjects = new ArrayList<SystemObject>();
        ClientDavInterface daVVerbindung = RahmenwerkService.getService().getObjektFactory().getDav();
        if (daVVerbindung != null) {
            DataModel dataModel = daVVerbindung.getDataModel();
            String[] stringArray = this.rootTypes;
            int n = this.rootTypes.length;
            int n2 = 0;
            while (n2 < n) {
                String rootType = stringArray[n2];
                systemObjects.add(dataModel.getObject(rootType));
                ++n2;
            }
        } else {
            this.setErrorMessage(Messages.SystemObjectAuswahl_ERROR_DAV_NOT_INITIALIZED);
        }
        this.filteredTree = new FilteredTree(parent, 0x800 | this.multi.getSwtConstant(), (PatternFilter)new PatternOrSubstringFilter(), true, true);
        this.filteredTree.getViewer().setContentProvider((IContentProvider)new SystemObjectTreeContentProvider());
        this.filteredTree.getViewer().setUseHashlookup(true);
        this.filteredTree.getViewer().setInput((Object)systemObjects.toArray());
        this.filteredTree.setInitialText(Messages.SystemObjectAuswahl_DefaultFilter);
        this.filteredTree.getViewer().setComparator(new ViewerComparator());
        if (!this.result.isEmpty()) {
            this.filteredTree.getViewer().setSelection((ISelection)new StructuredSelection(this.result.toArray()), true);
        }
        this.filteredTree.getViewer().addDoubleClickListener((IDoubleClickListener)new FilteredTreeDoubleClickListener());
        this.filteredTree.getViewer().addSelectionChangedListener((ISelectionChangedListener)new FilteredTreeSelectionChangedListener());
        this.filteredTree.getViewer().setLabelProvider((IBaseLabelProvider)new SystemObjectTypeLabelProvider());
        this.setControl((Control)this.filteredTree);
        this.validatePage();
    }

    public List<SystemObject> getAuswahl() {
        return Collections.unmodifiableList(this.result);
    }

    private void validatePage() {
        this.setPageComplete(!this.result.isEmpty());
    }

    public boolean performCancel() {
        this.result.clear();
        this.validatePage();
        return true;
    }

    public boolean performFinish() {
        return true;
    }

    private final class FilteredTreeDoubleClickListener
    implements IDoubleClickListener {
        private FilteredTreeDoubleClickListener() {
        }

        public void doubleClick(DoubleClickEvent event) {
            IWizardContainer iWizardContainer;
            IWizard w = SystemObjectAuswahlWizardPage.this.getWizard();
            if (w != null && w.canFinish() && (iWizardContainer = w.getContainer()) instanceof ComposedWizardDialog) {
                ComposedWizardDialog window = (ComposedWizardDialog)iWizardContainer;
                window.finishFromCode();
            }
        }
    }

    private final class FilteredTreeSelectionChangedListener
    implements ISelectionChangedListener {
        private FilteredTreeSelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            SystemObjectAuswahlWizardPage.this.result.clear();
            SystemObjectAuswahlWizardPage.this.result.addAll(event.getStructuredSelection().toList());
            Iterator<SystemObject> it = SystemObjectAuswahlWizardPage.this.result.iterator();
            while (it.hasNext()) {
                SystemObject object = it.next();
                switch (SystemObjectAuswahlWizardPage.this.selectionType) {
                    case OnlyInstances: {
                        if (!(object instanceof SystemObjectType)) break;
                        it.remove();
                        break;
                    }
                    case OnlyTypes: {
                        if (object instanceof SystemObjectType) break;
                        it.remove();
                        break;
                    }
                }
            }
            SystemObjectAuswahlWizardPage.this.validatePage();
        }
    }
}

