/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.sys.funclib.bitctrl.modell.util.cache.ui.internal;

import de.bsvrz.buv.rw.basislib.Rahmenwerk;
import de.bsvrz.buv.rw.basislib.dav.DavVerbindungsEvent;
import de.bsvrz.buv.rw.basislib.dav.DavVerbindungsListener;
import de.bsvrz.buv.rw.bitctrl.internal.RahmenwerkService;
import de.bsvrz.sys.funclib.bitctrl.modell.ObjektFactory;
import de.bsvrz.sys.funclib.bitctrl.modell.util.cache.AbstractCache;
import de.bsvrz.sys.funclib.bitctrl.modell.util.cache.AbstractDavVerbindungsCache;
import de.bsvrz.sys.funclib.bitctrl.modell.util.cache.AnzeigeVerfahrenCache;
import de.bsvrz.sys.funclib.bitctrl.modell.util.cache.AnzeigenCache;
import de.bsvrz.sys.funclib.bitctrl.modell.util.cache.AqCache;
import de.bsvrz.sys.funclib.bitctrl.modell.util.cache.MifCache;
import de.bsvrz.sys.funclib.bitctrl.modell.util.cache.ModellObjektCache;
import de.bsvrz.sys.funclib.bitctrl.modell.util.cache.MqCache;
import de.bsvrz.sys.funclib.bitctrl.modell.util.cache.NetzCache;
import de.bsvrz.sys.funclib.bitctrl.modell.util.cache.NetzCacheExtended;
import de.bsvrz.sys.funclib.bitctrl.modell.util.cache.RdsCache;
import de.bsvrz.sys.funclib.bitctrl.modell.util.cache.RdsMeldungenCache;
import de.bsvrz.sys.funclib.bitctrl.modell.util.cache.StrassenTeilSegmenteCache;
import de.bsvrz.sys.funclib.bitctrl.modell.util.cache.StreckenAbschnittCache;
import de.bsvrz.sys.funclib.bitctrl.modell.util.cache.TmcCache;
import de.bsvrz.sys.funclib.bitctrl.modell.util.cache.TmcLocationCodeCache;
import de.bsvrz.sys.funclib.bitctrl.modell.util.cache.ui.internal.CacheServiceImpl;
import de.bsvrz.sys.funclib.bitctrl.modell.util.cache.ui.internal.EclipseAnzeigeVerfahrenCache;
import de.bsvrz.sys.funclib.bitctrl.modell.util.cache.ui.internal.EclipseAnzeigenCache;
import de.bsvrz.sys.funclib.bitctrl.modell.util.cache.ui.internal.EclipseAqCache;
import de.bsvrz.sys.funclib.bitctrl.modell.util.cache.ui.internal.EclipseDavVerbindungsCache;
import de.bsvrz.sys.funclib.bitctrl.modell.util.cache.ui.internal.EclipseMifCache;
import de.bsvrz.sys.funclib.bitctrl.modell.util.cache.ui.internal.EclipseMqCache;
import de.bsvrz.sys.funclib.bitctrl.modell.util.cache.ui.internal.EclipseNetzCache;
import de.bsvrz.sys.funclib.bitctrl.modell.util.cache.ui.internal.EclipseNetzCacheExtended;
import de.bsvrz.sys.funclib.bitctrl.modell.util.cache.ui.internal.EclipseRdsCache;
import de.bsvrz.sys.funclib.bitctrl.modell.util.cache.ui.internal.EclipseRdsMeldungenCache;
import de.bsvrz.sys.funclib.bitctrl.modell.util.cache.ui.internal.EclipseStrassenTeilSegmenteCache;
import de.bsvrz.sys.funclib.bitctrl.modell.util.cache.ui.internal.EclipseStreckenAbschnittCache;
import de.bsvrz.sys.funclib.bitctrl.modell.util.cache.ui.internal.EclipseTmcCache;
import de.bsvrz.sys.funclib.bitctrl.modell.util.cache.ui.internal.EclipseTmcLocationCodeCache;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IAdapterFactory;

public class CacheAdapterFactory
implements IAdapterFactory {
    private final Map<Class<?>, CacheFactory<?, ?>> factories;

    public CacheAdapterFactory() {
        Rahmenwerk rahmenwerk = CacheServiceImpl.getService().getRahmenWerk();
        rahmenwerk.addDavVerbindungsListener(new DavVerbindungsListener(){

            public void verbindungHergestellt(DavVerbindungsEvent event) {
            }

            public boolean verbindungHalten(DavVerbindungsEvent event) {
                return false;
            }

            public void verbindungGetrennt(DavVerbindungsEvent event) {
                for (CacheFactory<?, ?> factory : CacheAdapterFactory.this.factories.values()) {
                    factory.reset();
                }
            }
        });
        this.factories = new HashMap();
        this.factories.put(AbstractDavVerbindungsCache.class, new CacheFactory<Class<AbstractDavVerbindungsCache>, AbstractDavVerbindungsCache>(){

            @Override
            public AbstractDavVerbindungsCache getCache(Class<AbstractDavVerbindungsCache> base) {
                return new EclipseDavVerbindungsCache();
            }
        });
        this.factories.put(ModellObjektCache.class, new CacheFactory<String, ModellObjektCache>(){

            @Override
            public ModellObjektCache getCache(String pid) {
                ModellObjektCache moCache = (ModellObjektCache)this.caches.get(pid);
                if (moCache == null) {
                    AbstractDavVerbindungsCache verbindungsCache = CacheAdapterFactory.this.getCache(null, AbstractDavVerbindungsCache.class);
                    moCache = new ModellObjektCache(pid, verbindungsCache);
                    this.caches.put(pid, moCache);
                } else {
                    CacheAdapterFactory.this.cacheReinitRequested((AbstractCache)moCache);
                }
                return moCache;
            }
        });
        this.factories.put(NetzCache.class, new CacheFactory<String, NetzCache>(){

            @Override
            public NetzCache getCache(String netz) {
                NetzCache netzCache = (NetzCache)this.caches.get(netz);
                if (netzCache == null) {
                    AbstractDavVerbindungsCache verbindungsCache = CacheAdapterFactory.this.getCache(null, AbstractDavVerbindungsCache.class);
                    ModellObjektCache moc = CacheAdapterFactory.this.getCache(netz, ModellObjektCache.class);
                    netzCache = new EclipseNetzCache(moc, verbindungsCache);
                    this.caches.put(netz, netzCache);
                } else {
                    CacheAdapterFactory.this.cacheReinitRequested((AbstractCache)netzCache);
                }
                return netzCache;
            }
        });
        this.factories.put(TmcCache.class, new CacheFactory<String, TmcCache>(){

            @Override
            public TmcCache getCache(String netz) {
                TmcCache tmcCache = (TmcCache)this.caches.get(netz);
                if (tmcCache == null) {
                    NetzCache netzCache = CacheAdapterFactory.this.getCache(netz, NetzCache.class);
                    AbstractDavVerbindungsCache verbindungsCache = CacheAdapterFactory.this.getCache(null, AbstractDavVerbindungsCache.class);
                    tmcCache = new EclipseTmcCache(netzCache, verbindungsCache);
                    this.caches.put(netz, tmcCache);
                } else {
                    CacheAdapterFactory.this.cacheReinitRequested((AbstractCache)tmcCache);
                }
                return tmcCache;
            }
        });
        this.factories.put(NetzCacheExtended.class, new CacheFactory<String, NetzCacheExtended>(){

            @Override
            public NetzCacheExtended getCache(String netz) {
                NetzCacheExtended netzCacheExtended = (NetzCacheExtended)this.caches.get(netz);
                if (netzCacheExtended == null) {
                    TmcCache tmcCache = CacheAdapterFactory.this.getCache(netz, TmcCache.class);
                    netzCacheExtended = new EclipseNetzCacheExtended(tmcCache);
                    this.caches.put(netz, netzCacheExtended);
                } else {
                    CacheAdapterFactory.this.cacheReinitRequested((AbstractCache)netzCacheExtended);
                }
                return netzCacheExtended;
            }
        });
        this.factories.put(MqCache.class, new CacheFactory<String, MqCache>(){

            @Override
            public MqCache getCache(String netz) {
                MqCache mqCache = (MqCache)this.caches.get(netz);
                if (mqCache == null) {
                    AbstractDavVerbindungsCache verbindungsCache = CacheAdapterFactory.this.getCache(null, AbstractDavVerbindungsCache.class);
                    NetzCache netzCache = CacheAdapterFactory.this.getCache(netz, NetzCache.class);
                    mqCache = new EclipseMqCache(netzCache, verbindungsCache);
                    this.caches.put(netz, mqCache);
                } else {
                    CacheAdapterFactory.this.cacheReinitRequested((AbstractCache)mqCache);
                }
                return mqCache;
            }
        });
        this.factories.put(AqCache.class, new CacheFactory<String, AqCache>(){

            @Override
            public AqCache getCache(String netz) {
                AqCache aqCache = (AqCache)this.caches.get(netz);
                if (aqCache == null) {
                    AbstractDavVerbindungsCache verbindungsCache = CacheAdapterFactory.this.getCache(null, AbstractDavVerbindungsCache.class);
                    aqCache = new EclipseAqCache(verbindungsCache);
                    this.caches.put(netz, aqCache);
                } else {
                    CacheAdapterFactory.this.cacheReinitRequested((AbstractCache)aqCache);
                }
                return aqCache;
            }
        });
        this.factories.put(StrassenTeilSegmenteCache.class, new CacheFactory<String, StrassenTeilSegmenteCache>(){

            @Override
            public StrassenTeilSegmenteCache getCache(String netz) {
                StrassenTeilSegmenteCache segmenteCache = (StrassenTeilSegmenteCache)this.caches.get(netz);
                if (segmenteCache == null) {
                    AbstractDavVerbindungsCache verbindungsCache = CacheAdapterFactory.this.getCache(null, AbstractDavVerbindungsCache.class);
                    NetzCacheExtended netzCacheExtended = CacheAdapterFactory.this.getCache(netz, NetzCacheExtended.class);
                    segmenteCache = new EclipseStrassenTeilSegmenteCache(verbindungsCache, netzCacheExtended);
                    this.caches.put(netz, segmenteCache);
                } else {
                    CacheAdapterFactory.this.cacheReinitRequested((AbstractCache)segmenteCache);
                }
                return segmenteCache;
            }
        });
        this.factories.put(StreckenAbschnittCache.class, new CacheFactory<String, StreckenAbschnittCache>(){

            @Override
            public StreckenAbschnittCache getCache(String netz) {
                StreckenAbschnittCache streckenAbschnittCache = (StreckenAbschnittCache)this.caches.get(netz);
                if (streckenAbschnittCache == null) {
                    StrassenTeilSegmenteCache strassenTeilSegmenteCache = CacheAdapterFactory.this.getCache(netz, StrassenTeilSegmenteCache.class);
                    streckenAbschnittCache = new EclipseStreckenAbschnittCache(strassenTeilSegmenteCache);
                    this.caches.put(netz, streckenAbschnittCache);
                } else {
                    CacheAdapterFactory.this.cacheReinitRequested((AbstractCache)streckenAbschnittCache);
                }
                return streckenAbschnittCache;
            }
        });
        this.factories.put(MifCache.class, new CacheFactory<String, MifCache>(){

            @Override
            public MifCache getCache(String base) {
                MifCache mifCache = (MifCache)this.caches.get(base);
                if (mifCache == null) {
                    AbstractDavVerbindungsCache verbindungsCache = CacheAdapterFactory.this.getCache(null, AbstractDavVerbindungsCache.class);
                    mifCache = new EclipseMifCache(verbindungsCache);
                    this.caches.put(base, mifCache);
                } else {
                    CacheAdapterFactory.this.cacheReinitRequested((AbstractCache)mifCache);
                }
                return mifCache;
            }
        });
        this.factories.put(AnzeigeVerfahrenCache.class, new CacheFactory<String, AnzeigeVerfahrenCache>(){

            @Override
            public AnzeigeVerfahrenCache getCache(String base) {
                AnzeigeVerfahrenCache azvCache = (AnzeigeVerfahrenCache)this.caches.get(base);
                if (azvCache == null) {
                    AbstractDavVerbindungsCache verbindungsCache = CacheAdapterFactory.this.getCache(null, AbstractDavVerbindungsCache.class);
                    azvCache = new EclipseAnzeigeVerfahrenCache(verbindungsCache);
                    this.caches.put(base, azvCache);
                } else {
                    CacheAdapterFactory.this.cacheReinitRequested((AbstractCache)azvCache);
                }
                return azvCache;
            }
        });
        this.factories.put(RdsCache.class, new CacheFactory<String, RdsCache>(){

            @Override
            public RdsCache getCache(String base) {
                RdsCache rdsCache = (RdsCache)this.caches.get(base);
                if (rdsCache == null) {
                    AbstractDavVerbindungsCache verbindungsCache = CacheAdapterFactory.this.getCache(null, AbstractDavVerbindungsCache.class);
                    rdsCache = new EclipseRdsCache(verbindungsCache);
                    this.caches.put(base, rdsCache);
                } else {
                    CacheAdapterFactory.this.cacheReinitRequested((AbstractCache)rdsCache);
                }
                return rdsCache;
            }
        });
        this.factories.put(TmcLocationCodeCache.class, new CacheFactory<String, TmcLocationCodeCache>(){

            @Override
            public TmcLocationCodeCache getCache(String base) {
                TmcLocationCodeCache tmcLocationCodeCache = (TmcLocationCodeCache)this.caches.get(base);
                if (tmcLocationCodeCache == null) {
                    AbstractDavVerbindungsCache verbindungsCache = CacheAdapterFactory.this.getCache(null, AbstractDavVerbindungsCache.class);
                    tmcLocationCodeCache = new EclipseTmcLocationCodeCache(verbindungsCache);
                    this.caches.put(base, tmcLocationCodeCache);
                } else {
                    CacheAdapterFactory.this.cacheReinitRequested((AbstractCache)tmcLocationCodeCache);
                }
                return tmcLocationCodeCache;
            }
        });
        this.factories.put(RdsMeldungenCache.class, new CacheFactory<String, RdsMeldungenCache>(){

            @Override
            public RdsMeldungenCache getCache(String lms) {
                RdsMeldungenCache rdsMeldungenCache = (RdsMeldungenCache)this.caches.get(lms);
                if (rdsMeldungenCache == null) {
                    AbstractDavVerbindungsCache verbindungsCache = CacheAdapterFactory.this.getCache(null, AbstractDavVerbindungsCache.class);
                    ModellObjektCache moc = CacheAdapterFactory.this.getCache(lms, ModellObjektCache.class);
                    RdsCache rdsCache = CacheAdapterFactory.this.getCache(RdsCache.class, RdsCache.class);
                    TmcLocationCodeCache tmcLocationCodeCache = CacheAdapterFactory.this.getCache(TmcLocationCodeCache.class, TmcLocationCodeCache.class);
                    rdsMeldungenCache = new EclipseRdsMeldungenCache(moc, verbindungsCache, rdsCache, tmcLocationCodeCache);
                    this.caches.put(lms, rdsMeldungenCache);
                } else {
                    CacheAdapterFactory.this.cacheReinitRequested((AbstractCache)rdsMeldungenCache);
                }
                return rdsMeldungenCache;
            }
        });
        this.factories.put(AnzeigenCache.class, new CacheFactory<String, AnzeigenCache>(){

            @Override
            public AnzeigenCache getCache(String base) {
                AnzeigenCache anzeigenCache = (AnzeigenCache)this.caches.get(base);
                if (anzeigenCache == null) {
                    AbstractDavVerbindungsCache verbindungsCache = CacheAdapterFactory.this.getCache(null, AbstractDavVerbindungsCache.class);
                    anzeigenCache = new EclipseAnzeigenCache(verbindungsCache);
                    this.caches.put(base, anzeigenCache);
                } else {
                    CacheAdapterFactory.this.cacheReinitRequested((AbstractCache)anzeigenCache);
                }
                return anzeigenCache;
            }
        });
    }

    protected void cacheReinitRequested(AbstractCache cache) {
        ObjektFactory objektFactory;
        if (cache != null && "canceled".equals(cache.getState()) && (objektFactory = RahmenwerkService.getService().getObjektFactory()) != null && objektFactory.isVerbunden()) {
            cache.redoInit();
        }
    }

    public synchronized AbstractCache getAdapter(Object adaptableObject, Class adapterType) {
        if (adaptableObject instanceof String) {
            String s = (String)adaptableObject;
            return this.getCache(s, adapterType);
        }
        if (adaptableObject instanceof Class) {
            Class c = (Class)adaptableObject;
            return this.getCache(c, adapterType);
        }
        return null;
    }

    private synchronized <K, T2 extends AbstractCache> T2 getCache(K netz, Class<T2> adapterType) {
        CacheFactory<?, ?> factory = this.factories.get(adapterType);
        if (factory != null) {
            return (T2)factory.getCache(netz);
        }
        return null;
    }

    public Class[] getAdapterList() {
        return new Class[]{ModellObjektCache.class, NetzCache.class, NetzCacheExtended.class, TmcCache.class, MqCache.class, StreckenAbschnittCache.class, MifCache.class, StrassenTeilSegmenteCache.class, RdsCache.class, TmcLocationCodeCache.class, RdsMeldungenCache.class, AbstractDavVerbindungsCache.class, AnzeigeVerfahrenCache.class, AnzeigenCache.class};
    }

    private static abstract class CacheFactory<T, C extends AbstractCache> {
        protected Map<T, C> caches = new HashMap<T, C>();

        private CacheFactory() {
        }

        public abstract C getCache(T var1);

        public void reset() {
            for (AbstractCache cache : this.caches.values()) {
                cache.setState("canceled");
            }
        }
    }
}

