/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.sys.funclib.bitctrl.modell.util.cache.ui.internal;

import de.bsvrz.buv.rw.basislib.Rahmenwerk;
import de.bsvrz.buv.rw.bitctrl.CacheService;
import de.bsvrz.sys.funclib.bitctrl.modell.ObjektFactory;
import de.bsvrz.sys.funclib.bitctrl.modell.SystemObjekt;
import de.bsvrz.sys.funclib.bitctrl.modell.util.cache.AnzeigeVerfahrenCache;
import de.bsvrz.sys.funclib.bitctrl.modell.util.cache.AnzeigenCache;
import de.bsvrz.sys.funclib.bitctrl.modell.util.cache.AqCache;
import de.bsvrz.sys.funclib.bitctrl.modell.util.cache.MifCache;
import de.bsvrz.sys.funclib.bitctrl.modell.util.cache.ModellObjektCache;
import de.bsvrz.sys.funclib.bitctrl.modell.util.cache.MqCache;
import de.bsvrz.sys.funclib.bitctrl.modell.util.cache.NetzCache;
import de.bsvrz.sys.funclib.bitctrl.modell.util.cache.NetzCacheExtended;
import de.bsvrz.sys.funclib.bitctrl.modell.util.cache.RdsCache;
import de.bsvrz.sys.funclib.bitctrl.modell.util.cache.RdsMeldungenCache;
import de.bsvrz.sys.funclib.bitctrl.modell.util.cache.StrassenTeilSegmenteCache;
import de.bsvrz.sys.funclib.bitctrl.modell.util.cache.StreckenAbschnittCache;
import de.bsvrz.sys.funclib.bitctrl.modell.util.cache.TmcCache;
import de.bsvrz.sys.funclib.bitctrl.modell.util.cache.TmcLocationCodeCache;
import java.util.List;
import org.eclipse.core.runtime.Platform;

public class CacheServiceImpl
implements CacheService {
    private static final String VERKEHRS_MODELL_OBJEKT = "-verkehrsModellObjekt";
    private Rahmenwerk rahmenWerk;
    private String defaultNetzPid;
    private ObjektFactory objektFactory;
    private static CacheServiceImpl service;

    public static CacheServiceImpl getService() {
        return service;
    }

    protected void activate() {
        service = this;
    }

    protected void deactivate() {
        service = null;
    }

    public Rahmenwerk getRahmenWerk() {
        return this.rahmenWerk;
    }

    protected void bindRahmenwerk(Rahmenwerk newRahmenWerk) {
        this.rahmenWerk = newRahmenWerk;
    }

    protected void unbindRahmenwerk(Rahmenwerk newRahmenWerk) {
        this.rahmenWerk = null;
    }

    @Override
    public ModellObjektCache getModellObjektCache(String netz) {
        return this.getCache(netz, ModellObjektCache.class);
    }

    @Override
    public NetzCache getNetzCache(String netz) {
        return this.getCache(netz, NetzCache.class);
    }

    @Override
    public NetzCacheExtended getNetzCacheExtended(String netz) {
        return this.getCache(netz, NetzCacheExtended.class);
    }

    @Override
    public TmcCache getTmcCache(String netz) {
        return this.getCache(netz, TmcCache.class);
    }

    @Override
    public MqCache getMqCache(String netz) {
        return this.getCache(netz, MqCache.class);
    }

    @Override
    public MifCache getMifCache() {
        return this.getCache(MifCache.class.getName(), MifCache.class);
    }

    @Override
    public AnzeigeVerfahrenCache getAnzeigeVerfahrenCache() {
        return this.getCache(AnzeigeVerfahrenCache.class.getName(), AnzeigeVerfahrenCache.class);
    }

    @Override
    public AqCache getAqCache(String netz) {
        return this.getCache(netz, AqCache.class);
    }

    @Override
    public AnzeigenCache getAnzeigenCache() {
        return this.getCache(AnzeigenCache.class.getName(), AnzeigenCache.class);
    }

    @Override
    public StrassenTeilSegmenteCache getStrassenTeilSegmenteCache(String netz) {
        return this.getCache(netz, StrassenTeilSegmenteCache.class);
    }

    @Override
    public StreckenAbschnittCache getStreckenAbschnittCache(String netz) {
        return this.getCache(netz, StreckenAbschnittCache.class);
    }

    @Override
    public RdsCache getRdsCache() {
        return this.getCache(RdsCache.class.getName(), RdsCache.class);
    }

    @Override
    public TmcLocationCodeCache getTmcLocationCodeCache() {
        return this.getCache(TmcLocationCodeCache.class.getName(), TmcLocationCodeCache.class);
    }

    @Override
    public RdsMeldungenCache getRdsMeldungenCache(String lms) {
        return this.getCache(lms, RdsMeldungenCache.class);
    }

    private <T> T getCache(String base, Class<T> t) {
        return (T)Platform.getAdapterManager().getAdapter((Object)base, t);
    }

    protected void bindObjektFactory(ObjektFactory newObjektFactory) {
        this.objektFactory = newObjektFactory;
    }

    protected void unbindObjektFactory(ObjektFactory newObjektFaktory) {
        this.objektFactory = null;
    }

    @Override
    public String getDefaultNetzPid() {
        if (this.defaultNetzPid == null) {
            if (this.rahmenWerk.getStartParameter().hasArgument(VERKEHRS_MODELL_OBJEKT)) {
                this.defaultNetzPid = this.rahmenWerk.getStartParameter().fetchArgument(VERKEHRS_MODELL_OBJEKT).asString();
            }
            if (this.defaultNetzPid == null && this.objektFactory != null && this.objektFactory.isVerbunden()) {
                List verkehrsmodellListe = this.objektFactory.bestimmeModellobjekte(new String[]{"typ.verkehrsModellNetz"});
                if (verkehrsmodellListe.size() == 1) {
                    this.defaultNetzPid = ((SystemObjekt)verkehrsmodellListe.iterator().next()).getPid();
                } else {
                    throw new IllegalStateException("Es sind mehrere VerkehrsModellNetz-Objekte in der Konfiguration und es wurde kein konkretes f\u00fcr die Verwendung im Rahmenwerk angegeben!");
                }
            }
        }
        if (this.defaultNetzPid == null) {
            throw new IllegalStateException("Es konnte kein Standard-VerkehrsModellNetz-Objekt ermittelt werden!");
        }
        return this.defaultNetzPid;
    }
}

