/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.sys.funclib.bitctrl.modell.util.cache.ui.internal;

import de.bsvrz.buv.rw.basislib.einstellungen.SpeicherKey;
import de.bsvrz.buv.rw.bitctrl.eclipse.modell.java.JavaModellEinstellungen;
import de.bsvrz.sys.funclib.bitctrl.modell.util.cache.AbstractCache;
import de.bsvrz.sys.funclib.bitctrl.modell.util.cache.ui.internal.Messages;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;

public class EclipseCacheMonitor
implements AbstractCache.CacheMonitor,
PropertyChangeListener {
    private static final long DEFAULT_TIME = 10000L;
    private static final String DEFAULT_NAME = "default";
    private RunTimes runTimes;
    private final Map<String, Long> startTimes = new HashMap<String, Long>();
    private Job currentJob;
    private final Set<AbstractCache> waitingCaches = new HashSet<AbstractCache>();
    private final Set<AbstractCache> initCaches = new HashSet<AbstractCache>();
    private final Set<AbstractCache> cancelCaches = new HashSet<AbstractCache>();
    private final Map<AbstractCache, Double> cacheProgress = new HashMap<AbstractCache, Double>();

    public EclipseCacheMonitor() {
        JavaModellEinstellungen<RunTimes> jme = new JavaModellEinstellungen<RunTimes>(RunTimes.class);
        this.runTimes = (RunTimes)jme.getModellEinstellungen(SpeicherKey.allgemeinLokal(), DEFAULT_NAME);
        if (this.runTimes == null) {
            this.runTimes = new RunTimes();
        }
    }

    public synchronized void monitorCache(AbstractCache cache) {
        if (this.currentJob != null) {
            this.currentJob.cancel();
            this.currentJob = null;
            this.notifyAll();
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.initCaches.remove(cache);
        this.cancelCaches.remove(cache);
        this.waitingCaches.add(cache);
        this.cacheProgress.put(cache, 0.0);
        cache.addPropertyChangeListener("state", (PropertyChangeListener)this);
        cache.addPropertyChangeListener("progress", (PropertyChangeListener)this);
        this.currentJob = new AllCachesProgressJob();
        this.currentJob.schedule();
    }

    @Override
    public synchronized void propertyChange(PropertyChangeEvent evt) {
        AbstractCache cache = (AbstractCache)evt.getSource();
        if ("state".equals(evt.getPropertyName())) {
            String newValue = (String)evt.getNewValue();
            if ("initialized".equals(newValue)) {
                cache.removePropertyChangeListener("state", (PropertyChangeListener)this);
                cache.removePropertyChangeListener("progress", (PropertyChangeListener)this);
                this.cacheProgress.put(cache, 1.0);
                if (this.waitingCaches.contains(cache)) {
                    this.waitingCaches.remove(cache);
                    this.initCaches.add(cache);
                    this.notifyAll();
                }
                String className = cache.getClass().getName();
                long time = System.currentTimeMillis() - this.startTimes.get(className);
                this.runTimes.getTimes().put(className, time);
            } else if ("canceled".equals(newValue)) {
                cache.removePropertyChangeListener("state", (PropertyChangeListener)this);
                cache.removePropertyChangeListener("progress", (PropertyChangeListener)this);
                this.waitingCaches.remove(cache);
                this.cancelCaches.add(cache);
                this.cacheProgress.put(cache, 1.0);
                this.notifyAll();
            } else if ("started".equals(newValue)) {
                this.startTimes.put(cache.getClass().getName(), System.currentTimeMillis());
            }
        } else if ("progress".equals(evt.getPropertyName())) {
            this.cacheProgress.put(cache, Math.max(0.0, Math.min(1.0, (Double)evt.getNewValue())));
            this.notifyAll();
        }
    }

    private final class AllCachesProgressJob
    extends Job {
        private AllCachesProgressJob() {
            super(Messages.EclipseCacheMonitor_JobHeadText);
            IProgressMonitor.class.getName();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected IStatus run(IProgressMonitor monitor) {
            EclipseCacheMonitor eclipseCacheMonitor = EclipseCacheMonitor.this;
            synchronized (eclipseCacheMonitor) {
                try {
                    int maxSize = 0;
                    for (Map.Entry<AbstractCache, Double> entry : EclipseCacheMonitor.this.cacheProgress.entrySet()) {
                        Long time = EclipseCacheMonitor.this.runTimes.getTimes().get(entry.getKey().getClass().getName());
                        if (time == null || 0L == time) {
                            time = 10000L;
                        }
                        maxSize = (int)((long)maxSize + time);
                    }
                    monitor.beginTask("", maxSize);
                    monitor.worked(EclipseCacheMonitor.this.initCaches.size());
                    int currentSize = 0;
                    while (!EclipseCacheMonitor.this.waitingCaches.isEmpty() && !monitor.isCanceled()) {
                        try {
                            String message = EclipseCacheMonitor.this.cancelCaches.isEmpty() ? Messages.EclipseCacheMonitor_JobSubTextOk : Messages.EclipseCacheMonitor_JobSubTextError;
                            Object[] sizes = new Object[]{EclipseCacheMonitor.this.waitingCaches.size(), EclipseCacheMonitor.this.initCaches.size(), EclipseCacheMonitor.this.cancelCaches.size()};
                            monitor.subTask(NLS.bind((String)message, (Object[])sizes));
                            EclipseCacheMonitor.this.wait();
                            int newSize = 0;
                            for (Map.Entry<AbstractCache, Double> entry : EclipseCacheMonitor.this.cacheProgress.entrySet()) {
                                Long time = EclipseCacheMonitor.this.runTimes.getTimes().get(entry.getKey().getClass().getName());
                                if (time == null) {
                                    time = 10000L;
                                }
                                newSize = (int)((double)newSize + entry.getValue() * (double)time.longValue());
                            }
                            monitor.worked(newSize - currentSize);
                            currentSize = newSize;
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                            EclipseCacheMonitor.this.waitingCaches.clear();
                            EclipseCacheMonitor.this.initCaches.clear();
                            EclipseCacheMonitor.this.cacheProgress.clear();
                            EclipseCacheMonitor.this.currentJob = null;
                            monitor.setCanceled(true);
                            IStatus iStatus = Status.CANCEL_STATUS;
                            EclipseCacheMonitor.this.notifyAll();
                            JavaModellEinstellungen<RunTimes> jme = new JavaModellEinstellungen<RunTimes>(RunTimes.class);
                            try {
                                jme.setModellEinstellungen(SpeicherKey.allgemeinLokal(), EclipseCacheMonitor.DEFAULT_NAME, EclipseCacheMonitor.this.runTimes);
                            }
                            catch (IOException e2) {
                                e2.printStackTrace();
                            }
                            return iStatus;
                        }
                    }
                    if (EclipseCacheMonitor.this.waitingCaches.isEmpty()) {
                        EclipseCacheMonitor.this.initCaches.clear();
                        EclipseCacheMonitor.this.cacheProgress.clear();
                    }
                    EclipseCacheMonitor.this.currentJob = null;
                    monitor.done();
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                finally {
                    EclipseCacheMonitor.this.notifyAll();
                    JavaModellEinstellungen<RunTimes> jme = new JavaModellEinstellungen<RunTimes>(RunTimes.class);
                    try {
                        jme.setModellEinstellungen(SpeicherKey.allgemeinLokal(), EclipseCacheMonitor.DEFAULT_NAME, EclipseCacheMonitor.this.runTimes);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public static class RunTimes {
        private Map<String, Long> times = new HashMap<String, Long>();

        public Map<String, Long> getTimes() {
            return this.times;
        }

        public void setTimes(Map<String, Long> times) {
            this.times = times;
        }
    }
}

