/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.bastmodell.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Verkehrsstaerke (Anzahl der Fahrzeuge) pro Stunde mit
					Kennung.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlBastVerkehrsStaerke implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeStunde
			 _wert
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.bastmodell.attribute.AttBastKennung
			 _kennung
			;
	
		/**
		Verkehrsstaerke (Anzahl der Fahrzeuge) im Messintervall.
		<p>
		
		</p>
		
		@return der Wert von Wert.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeStunde
			 getWert() {
			return _wert;
		}
	
		/**
		Verkehrsstaerke (Anzahl der Fahrzeuge) im Messintervall.
		<p>
		
		</p>
		
		@param _wert der neue Wert von Wert.
		*/
		public void setWert(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeStunde
		 _wert) {
			this._wert = _wert;
		}
	
		/**
		Bast-Kennung.
		<p>
		
		</p>
		
		@return der Wert von Kennung.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.bastmodell.attribute.AttBastKennung
			 getKennung() {
			return _kennung;
		}
	
		/**
		Bast-Kennung.
		<p>
		
		</p>
		
		@param _kennung der neue Wert von Kennung.
		*/
		public void setKennung(de.bsvrz.sys.funclib.bitctrl.modell.bastmodell.attribute.AttBastKennung
		 _kennung) {
			this._kennung = _kennung;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// GanzzahlAttributTyp
				if (getWert() != null) {
	                if (getWert().isZustand()) {
	                    datum.getUnscaledValue("Wert").setText(getWert().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Wert").set(getWert().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getKennung() != null) {
	                if (getKennung().isZustand()) {
	                    datum.getUnscaledValue("Kennung").setText(getKennung().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Kennung").set(getKennung().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Wert").isState()) {
							setWert(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeStunde
							.getZustand(daten.getScaledValue("Wert").getText()));
						} else {
						setWert(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeStunde
						(daten.
							getUnscaledValue
						("Wert").
								intValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Kennung").isState()) {
							setKennung(de.bsvrz.sys.funclib.bitctrl.modell.bastmodell.attribute.AttBastKennung
							.getZustand(daten.getScaledValue("Kennung").getText()));
						} else {
						setKennung(new de.bsvrz.sys.funclib.bitctrl.modell.bastmodell.attribute.AttBastKennung
						(daten.
							getUnscaledValue
						("Kennung").
								byteValue
						()));
						}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlBastVerkehrsStaerke clone() {
		AtlBastVerkehrsStaerke klon = new AtlBastVerkehrsStaerke();
		
						klon.setWert(getWert());
						klon.setKennung(getKennung());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
