/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.bastmodell.objekte;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Definiert eine Applikation zur Erstellung von
					BAST-Dateien.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public interface BastDateiModul extends de.bsvrz.sys.funclib.bitctrl.modell.KonfigurationsObjekt
	,de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.KonfigurationsObjekt
	
	
	
	{

	/** Die PID des Systemobjekttyps im Datenverteiler. */
	public static final String PID = "typ.bastDateiModul"; 
	
	/*
	 * Beginn Abschnitt Mengen
	 */
	

	/*
	 * Ende Abschnitt Mengen
	 */

	/*
	 * Beginn Abschnitt Attributgruppen
	 */

	/**
	Parameter für die Definition von Ferien.
	<p>
	
	</p>
	@return der Datensatz BastFerienParameter.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.bastmodell.parameter.PdBastFerienParameter getPdBastFerienParameter();
	
	/**
	Attributgruppe zur Speicherung von Default-Parameterdatensätzen für alle Parameter-Attributgruppen eines Typs.
	<p>
	
	</p>
	@return der Datensatz DefaultParameterdatensaetze.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdDefaultParameterdatensaetze getKdDefaultParameterdatensaetze();
	
	/**
	Parameter zur Ertellung einer BastDatei.
	<p>
	
	</p>
	@return der Datensatz BastFtpParameter.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.bastmodell.parameter.PdBastFtpParameter getPdBastFtpParameter();
	
	/**
	Attributgruppe zur Speicherung von beschreibenden Informationen zu einem Objekt.
	<p>
	
	</p>
	@return der Datensatz Info.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdInfo getKdInfo();
	
	/**
	Parameter zur Vermailung von Bastdateien.
	<p>
	
	</p>
	@return der Datensatz BcBastDateiCommand.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.bastmodell.onlinedaten.OdBcBastDateiCommand getOdBcBastDateiCommand();
	
	/**
	Verwaltet bis zu zehn alternative Bezeichnungen.
	<p>
	
	</p>
	@return der Datensatz AlternativeObjektbezeichnung.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdAlternativeObjektbezeichnung getKdAlternativeObjektbezeichnung();
	
	/**
	Parameter zur automatischen Bastdatei-Erstellung.
	<p>
	
	</p>
	@return der Datensatz BastAutomation.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.bastmodell.parameter.PdBastAutomation getPdBastAutomation();
	
	/**
	Parameter zur Erstellung einer BastDatei.
	<p>
	
	</p>
	@return der Datensatz BastDateiParameter.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.bastmodell.parameter.PdBastDateiParameter getPdBastDateiParameter();
	
	/**
	Parameter fuer die BASt-Info-Datei.
	<p>
	
	</p>
	@return der Datensatz BastInfo.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.bastmodell.parameter.PdBastInfo getPdBastInfo();
	
	/**
	Parameter zur Versendung von E-Mail.
	<p>
	
	</p>
	@return der Datensatz MailVersandParameter.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.bastmodell.parameter.PdMailVersandParameter getPdMailVersandParameter();
	
	/**
	Parameter zur Vermailung von Bastdateien.
	<p>
	
	</p>
	@return der Datensatz BcBastDateiMailParameter.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.bastmodell.parameter.PdBcBastDateiMailParameter getPdBcBastDateiMailParameter();
	
	
	/*
	 * Ende Abschnitt Attributgruppen
	 */
	 
}
