/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.bastmodell.onlinedaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Bast-Daten:Anzahl der Fahrzeuge fuer einen Fahrstreifen je
					Stundenintervall.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class OdBastDatenAnzahl extends AbstractOnlineDatensatz<OdBastDatenAnzahl.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.Nachplausibilisiert,
					Aspekte.Vorplausibilisiert,
					Aspekte.Berechnet,
				};
			}
	
			/**
			 * Aspekt für nachplausibilisierte Bast-Daten.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt Nachplausibilisiert = new Aspekte("Nachplausibilisiert", "asp.nachplausibilisiert");
			
			/**
			 * Aspekt für vorplausibilisierte Bast-Daten.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt Vorplausibilisiert = new Aspekte("Vorplausibilisiert", "asp.vorplausibilisiert");
			
			/**
			 * Aspekt für berechnete Bast-Daten.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt Berechnet = new Aspekte("Berechnet", "asp.berechnet");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.bastmodell.attribute.AtlBastVerkehrsStaerke
				 _qMot
				= new de.bsvrz.sys.funclib.bitctrl.modell.bastmodell.attribute.AtlBastVerkehrsStaerke
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.bastmodell.attribute.AtlBastVerkehrsStaerke
				 _qPkw
				= new de.bsvrz.sys.funclib.bitctrl.modell.bastmodell.attribute.AtlBastVerkehrsStaerke
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.bastmodell.attribute.AtlBastVerkehrsStaerke
				 _qLfw
				= new de.bsvrz.sys.funclib.bitctrl.modell.bastmodell.attribute.AtlBastVerkehrsStaerke
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.bastmodell.attribute.AtlBastVerkehrsStaerke
				 _qPmA
				= new de.bsvrz.sys.funclib.bitctrl.modell.bastmodell.attribute.AtlBastVerkehrsStaerke
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.bastmodell.attribute.AtlBastVerkehrsStaerke
				 _qBus
				= new de.bsvrz.sys.funclib.bitctrl.modell.bastmodell.attribute.AtlBastVerkehrsStaerke
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.bastmodell.attribute.AtlBastVerkehrsStaerke
				 _qLoA
				= new de.bsvrz.sys.funclib.bitctrl.modell.bastmodell.attribute.AtlBastVerkehrsStaerke
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.bastmodell.attribute.AtlBastVerkehrsStaerke
				 _qLmA
				= new de.bsvrz.sys.funclib.bitctrl.modell.bastmodell.attribute.AtlBastVerkehrsStaerke
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.bastmodell.attribute.AtlBastVerkehrsStaerke
				 _qSat
				= new de.bsvrz.sys.funclib.bitctrl.modell.bastmodell.attribute.AtlBastVerkehrsStaerke
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.bastmodell.attribute.AtlBastVerkehrsStaerke
				 _qSon
				= new de.bsvrz.sys.funclib.bitctrl.modell.bastmodell.attribute.AtlBastVerkehrsStaerke
				()
				;
		
			/**
			Fahrzeugmenge Krad.
			<p>
			
			</p>
			
			@return der Wert von QMot.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.bastmodell.attribute.AtlBastVerkehrsStaerke
				 getQMot() {
				return _qMot;
			}
		
			/**
			Fahrzeugmenge Krad.
			<p>
			
			</p>
			
			@param _qMot der neue Wert von QMot.
			*/
			public void setQMot(de.bsvrz.sys.funclib.bitctrl.modell.bastmodell.attribute.AtlBastVerkehrsStaerke
			 _qMot) {
				this._qMot = _qMot;
			}
		
			/**
			Fahrzeugmenge Pkw.
			<p>
			
			</p>
			
			@return der Wert von QPkw.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.bastmodell.attribute.AtlBastVerkehrsStaerke
				 getQPkw() {
				return _qPkw;
			}
		
			/**
			Fahrzeugmenge Pkw.
			<p>
			
			</p>
			
			@param _qPkw der neue Wert von QPkw.
			*/
			public void setQPkw(de.bsvrz.sys.funclib.bitctrl.modell.bastmodell.attribute.AtlBastVerkehrsStaerke
			 _qPkw) {
				this._qPkw = _qPkw;
			}
		
			/**
			Fahrzeugmenge Lieferwagen.
			<p>
			
			</p>
			
			@return der Wert von QLfw.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.bastmodell.attribute.AtlBastVerkehrsStaerke
				 getQLfw() {
				return _qLfw;
			}
		
			/**
			Fahrzeugmenge Lieferwagen.
			<p>
			
			</p>
			
			@param _qLfw der neue Wert von QLfw.
			*/
			public void setQLfw(de.bsvrz.sys.funclib.bitctrl.modell.bastmodell.attribute.AtlBastVerkehrsStaerke
			 _qLfw) {
				this._qLfw = _qLfw;
			}
		
			/**
			Fahrzeugmenge Pkw mit Anhaenger.
			<p>
			
			</p>
			
			@return der Wert von QPmA.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.bastmodell.attribute.AtlBastVerkehrsStaerke
				 getQPmA() {
				return _qPmA;
			}
		
			/**
			Fahrzeugmenge Pkw mit Anhaenger.
			<p>
			
			</p>
			
			@param _qPmA der neue Wert von QPmA.
			*/
			public void setQPmA(de.bsvrz.sys.funclib.bitctrl.modell.bastmodell.attribute.AtlBastVerkehrsStaerke
			 _qPmA) {
				this._qPmA = _qPmA;
			}
		
			/**
			Fahrzeugmenge Busse.
			<p>
			
			</p>
			
			@return der Wert von QBus.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.bastmodell.attribute.AtlBastVerkehrsStaerke
				 getQBus() {
				return _qBus;
			}
		
			/**
			Fahrzeugmenge Busse.
			<p>
			
			</p>
			
			@param _qBus der neue Wert von QBus.
			*/
			public void setQBus(de.bsvrz.sys.funclib.bitctrl.modell.bastmodell.attribute.AtlBastVerkehrsStaerke
			 _qBus) {
				this._qBus = _qBus;
			}
		
			/**
			Fahrzeugmenge Lkw ohne Anhaenger.
			<p>
			
			</p>
			
			@return der Wert von QLoA.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.bastmodell.attribute.AtlBastVerkehrsStaerke
				 getQLoA() {
				return _qLoA;
			}
		
			/**
			Fahrzeugmenge Lkw ohne Anhaenger.
			<p>
			
			</p>
			
			@param _qLoA der neue Wert von QLoA.
			*/
			public void setQLoA(de.bsvrz.sys.funclib.bitctrl.modell.bastmodell.attribute.AtlBastVerkehrsStaerke
			 _qLoA) {
				this._qLoA = _qLoA;
			}
		
			/**
			Fahrzeugmenge Lkw mit Anhaenger.
			<p>
			
			</p>
			
			@return der Wert von QLmA.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.bastmodell.attribute.AtlBastVerkehrsStaerke
				 getQLmA() {
				return _qLmA;
			}
		
			/**
			Fahrzeugmenge Lkw mit Anhaenger.
			<p>
			
			</p>
			
			@param _qLmA der neue Wert von QLmA.
			*/
			public void setQLmA(de.bsvrz.sys.funclib.bitctrl.modell.bastmodell.attribute.AtlBastVerkehrsStaerke
			 _qLmA) {
				this._qLmA = _qLmA;
			}
		
			/**
			Fahrzeugmenge Sattelfahrzeuge.
			<p>
			
			</p>
			
			@return der Wert von QSat.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.bastmodell.attribute.AtlBastVerkehrsStaerke
				 getQSat() {
				return _qSat;
			}
		
			/**
			Fahrzeugmenge Sattelfahrzeuge.
			<p>
			
			</p>
			
			@param _qSat der neue Wert von QSat.
			*/
			public void setQSat(de.bsvrz.sys.funclib.bitctrl.modell.bastmodell.attribute.AtlBastVerkehrsStaerke
			 _qSat) {
				this._qSat = _qSat;
			}
		
			/**
			Fahrzeugmenge nicht klassifizierbar.
			<p>
			
			</p>
			
			@return der Wert von QSon.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.bastmodell.attribute.AtlBastVerkehrsStaerke
				 getQSon() {
				return _qSon;
			}
		
			/**
			Fahrzeugmenge nicht klassifizierbar.
			<p>
			
			</p>
			
			@param _qSon der neue Wert von QSon.
			*/
			public void setQSon(de.bsvrz.sys.funclib.bitctrl.modell.bastmodell.attribute.AtlBastVerkehrsStaerke
			 _qSon) {
				this._qSon = _qSon;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// AttributListenDefinition
						getQMot().bean2Atl(datum.getItem("qMot"), factory);
					// AttributListenDefinition
						getQPkw().bean2Atl(datum.getItem("qPkw"), factory);
					// AttributListenDefinition
						getQLfw().bean2Atl(datum.getItem("qLfw"), factory);
					// AttributListenDefinition
						getQPmA().bean2Atl(datum.getItem("qPmA"), factory);
					// AttributListenDefinition
						getQBus().bean2Atl(datum.getItem("qBus"), factory);
					// AttributListenDefinition
						getQLoA().bean2Atl(datum.getItem("qLoA"), factory);
					// AttributListenDefinition
						getQLmA().bean2Atl(datum.getItem("qLmA"), factory);
					// AttributListenDefinition
						getQSat().bean2Atl(datum.getItem("qSat"), factory);
					// AttributListenDefinition
						getQSon().bean2Atl(datum.getItem("qSon"), factory);
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// AttributListenDefinition
						getQMot().atl2Bean(daten.getItem("qMot"), factory);
					// AttributListenDefinition
						getQPkw().atl2Bean(daten.getItem("qPkw"), factory);
					// AttributListenDefinition
						getQLfw().atl2Bean(daten.getItem("qLfw"), factory);
					// AttributListenDefinition
						getQPmA().atl2Bean(daten.getItem("qPmA"), factory);
					// AttributListenDefinition
						getQBus().atl2Bean(daten.getItem("qBus"), factory);
					// AttributListenDefinition
						getQLoA().atl2Bean(daten.getItem("qLoA"), factory);
					// AttributListenDefinition
						getQLmA().atl2Bean(daten.getItem("qLmA"), factory);
					// AttributListenDefinition
						getQSat().atl2Bean(daten.getItem("qSat"), factory);
					// AttributListenDefinition
						getQSon().atl2Bean(daten.getItem("qSon"), factory);
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon._qMot = getQMot().clone();
							klon._qPkw = getQPkw().clone();
							klon._qLfw = getQLfw().clone();
							klon._qPmA = getQPmA().clone();
							klon._qBus = getQBus().clone();
							klon._qLoA = getQLoA().clone();
							klon._qLmA = getQLmA().clone();
							klon._qSat = getQSat().clone();
							klon._qSon = getQSon().clone();
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.bastDatenAnzahl";

	/**
	 * Initialisiert den Onlinedatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public OdBastDatenAnzahl(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
